/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private IMappingCollector<NormalizedSimpleStack, Long> mapper;

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        mapper.setValueBefore(NormalizedSimpleStack.getFor(FluidRegistry.WATER), Integer.MIN_VALUE);
        mapper.setValueBefore(NormalizedSimpleStack.getFor(FluidRegistry.LAVA), 64);
        HashMap fixValue = Maps.newHashMap();
        fixValue.put("milk", 16);
        for (Map.Entry entry : fixValue.entrySet()) {
            Fluid f = FluidRegistry.getFluid((String)((String)entry.getKey()));
            if (f == null) continue;
            mapper.setValueBefore(NormalizedSimpleStack.getFor(f), (Integer)((Comparable)entry.getValue()));
        }
        HashMap molten = Maps.newHashMap();
        molten.put("obsidian.molten", NormalizedSimpleStack.getFor(Blocks.field_150343_Z));
        molten.put("glass.molten", NormalizedSimpleStack.getFor(Blocks.field_150359_w));
        molten.put("ender", NormalizedSimpleStack.getFor(Items.field_151079_bi));
        for (Map.Entry entry : molten.entrySet()) {
            Fluid f = FluidRegistry.getFluid((String)((String)entry.getKey()));
            if (f == null) continue;
            mapper.addConversion(1, NormalizedSimpleStack.getFor(f), Arrays.asList((NormalizedSimpleStack)entry.getValue()));
        }
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            Fluid fluid = data.fluid.getFluid();
            mapper.addConversion(1, NormalizedSimpleStack.getFor(data.filledContainer), Arrays.asList(NormalizedSimpleStack.getFor(data.emptyContainer), NormalizedSimpleStack.getFor(fluid)));
            List<ItemStack> odItems = FluidMapper.getODEntriesForFluid(FluidMapper.handleFluidName(data.fluid.getFluid()));
            for (ItemStack itemStack : odItems) {
                mapper.addConversion(1, NormalizedSimpleStack.getFor(fluid), Arrays.asList(NormalizedSimpleStack.getFor(itemStack)));
            }
        }
    }

    @Override
    public String getName() {
        return "FluidMapper";
    }

    @Override
    public String getDescription() {
        return "Adds Conversions for fluid container items and fluids.";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private static String handleFluidName(Fluid fluid) {
        String name = fluid.getName();
        if (name.endsWith(".molten")) {
            name = name.substring(0, name.indexOf(".molten"));
        } else if (name.endsWith(".liquid")) {
            name = name.substring(0, name.indexOf(".liquid"));
        }
        return name;
    }

    private static List<ItemStack> getODEntriesForFluid(String name) {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        List<ItemStack> list = ItemHelper.getODItems("ingot" + name);
        if (list.isEmpty() && (list = ItemHelper.getODItems("dust" + name)).isEmpty()) {
            list = ItemHelper.getODItems("gem" + name);
        }
        return list;
    }
}

