/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK3Tile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.utils.ComparatorHelper;
import moze_intel.projecte.utils.Constants;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class Collector
extends BlockDirection {
    @SideOnly(value=Side.CLIENT)
    private IIcon front;
    @SideOnly(value=Side.CLIENT)
    private IIcon top;
    private int tier;

    public Collector(int tier) {
        super(Material.field_151592_s);
        this.func_149663_c("pe_collector_MK" + tier);
        this.func_149715_a(Constants.COLLECTOR_LIGHT_VALS[tier - 1]);
        this.func_149711_c(0.3f);
        this.tier = tier;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            switch (this.tier) {
                case 1: {
                    player.openGui((Object)PECore.instance, 6, world, x, y, z);
                    break;
                }
                case 2: {
                    player.openGui((Object)PECore.instance, 7, world, x, y, z);
                    break;
                }
                case 3: {
                    player.openGui((Object)PECore.instance, 8, world, x, y, z);
                }
            }
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entLiving, ItemStack stack) {
        this.setFacingMeta(world, x, y, z, (EntityPlayer)entLiving);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("ProjectEBlock") && tile instanceof TileEmc) {
            stack.field_77990_d.func_74768_a("x", x);
            stack.field_77990_d.func_74768_a("y", y);
            stack.field_77990_d.func_74768_a("z", z);
            tile.func_145839_a(stack.field_77990_d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("projecte:collectors/other");
        this.front = register.func_94245_a("projecte:collectors/front");
        this.top = register.func_94245_a("projecte:collectors/top_" + Integer.toString(this.tier));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == 1) {
            return this.top;
        }
        return side != meta ? this.field_149761_L : this.front;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (this.tier) {
            case 3: {
                return new CollectorMK3Tile();
            }
            case 2: {
                return new CollectorMK2Tile();
            }
            case 1: {
                return new CollectorMK1Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        return ComparatorHelper.getForCollector(world, x, y, z);
    }
}

