/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.AchievementHandler;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.MetaBlock;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone() {
        super("philosophers_stone", (byte)4, new String[]{StatCollector.func_74838_a((String)"pe.philstone.mode1"), StatCollector.func_74838_a((String)"pe.philstone.mode2"), StatCollector.func_74838_a((String)"pe.philstone.mode3")});
        this.func_77642_a(this);
        this.setNoRepair();
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, int sideHit, float px, float py, float pz) {
        MetaBlock result;
        if (world.field_72995_K) {
            return false;
        }
        MetaBlock mBlock = new MetaBlock(world, blockX, blockY, blockZ);
        if (mBlock.getBlock() != Blocks.field_150350_a) {
            TileEntity tile = world.func_147438_o(blockX, blockY, blockZ);
            if (player.func_70093_af() && tile instanceof TileEmc) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("ProjectEBlock", true);
                tile.func_145841_b(nbt);
                if (mBlock.getBlock() == ObjHandler.dmFurnaceOn) {
                    mBlock.setBlock(ObjHandler.dmFurnaceOff);
                } else if (mBlock.getBlock() == ObjHandler.rmFurnaceOn) {
                    mBlock.setBlock(ObjHandler.rmFurnaceOff);
                }
                ItemStack s = mBlock.toItemStack();
                if (s.func_77981_g()) {
                    s.func_77964_b(world.func_72805_g(blockX, blockY, blockZ));
                } else {
                    s.func_77964_b(0);
                }
                s.func_77982_d(nbt);
                world.func_147475_p(blockX, blockY, blockZ);
                world.func_147465_d(blockX, blockY, blockZ, Blocks.field_150350_a, 0, 2);
                WorldHelper.spawnEntityItem(world, s, blockX, blockY, blockZ);
            }
        }
        if ((result = WorldTransmutations.getWorldTransmutation(world, blockX, blockY, blockZ, player.func_70093_af())) != null) {
            Coordinates pos = new Coordinates(blockX, blockY, blockZ);
            byte mode = this.getMode(stack);
            byte charge = this.getCharge(stack);
            ForgeDirection direction = ForgeDirection.getOrientation((int)sideHit);
            if (mode == 0) {
                this.doWorldTransmutation(world, mBlock, result, pos, 0, 0, charge, player);
            } else if (mode == 1) {
                this.getAxisOrientedPanel(direction, charge, mBlock, result, pos, world, player);
            } else {
                this.getAxisOrientedLine(direction, charge, mBlock, result, pos, world, player);
            }
            world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
            PlayerHelper.swingItem(player);
        }
        return true;
    }

    private void getAxisOrientedPanel(ForgeDirection direction, int charge, MetaBlock pointed, MetaBlock result, Coordinates coords, World world, EntityPlayer player) {
        int side = direction.offsetY != 0 ? 0 : (direction.offsetX != 0 ? 1 : 2);
        this.doWorldTransmutation(world, pointed, result, coords, 1, side, charge, player);
    }

    private void getAxisOrientedLine(ForgeDirection direction, int charge, MetaBlock pointed, MetaBlock result, Coordinates coords, World world, EntityPlayer player) {
        String dir;
        int side = direction.offsetX != 0 ? 0 : (direction.offsetZ != 0 ? 1 : ((dir = Direction.field_82373_c[MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3]).equals("NORTH") || dir.equals("SOUTH") ? 0 : 1));
        this.doWorldTransmutation(world, pointed, result, coords, 2, side, charge, player);
    }

    private void doWorldTransmutation(World world, MetaBlock pointed, MetaBlock result, Coordinates coords, int type, int side, int charge, EntityPlayer player) {
        if (type == 0) {
            for (int i = coords.x - charge; i <= coords.x + charge; ++i) {
                for (int j = coords.y - charge; j <= coords.y + charge; ++j) {
                    for (int k = coords.z - charge; k <= coords.z + charge; ++k) {
                        this.changeBlock(world, pointed, result, i, j, k, player);
                    }
                }
            }
        } else if (type == 1) {
            if (side == 0) {
                for (int i = coords.x - charge; i <= coords.x + charge; ++i) {
                    for (int j = coords.z - charge; j <= coords.z + charge; ++j) {
                        this.changeBlock(world, pointed, result, i, coords.y, j, player);
                    }
                }
            } else if (side == 1) {
                for (int i = coords.y - charge; i <= coords.y + charge; ++i) {
                    for (int j = coords.z - charge; j <= coords.z + charge; ++j) {
                        this.changeBlock(world, pointed, result, coords.x, i, j, player);
                    }
                }
            } else {
                for (int i = coords.x - charge; i <= coords.x + charge; ++i) {
                    for (int j = coords.y - charge; j <= coords.y + charge; ++j) {
                        this.changeBlock(world, pointed, result, i, j, coords.z, player);
                    }
                }
            }
        } else if (side == 0) {
            for (int i = coords.z - charge; i <= coords.z + charge; ++i) {
                this.changeBlock(world, pointed, result, coords.x, coords.y, i, player);
            }
        } else {
            for (int i = coords.x - charge; i <= coords.x + charge; ++i) {
                this.changeBlock(world, pointed, result, i, coords.y, coords.z, player);
            }
        }
    }

    private void changeBlock(World world, MetaBlock pointed, MetaBlock result, int x, int y, int z, EntityPlayer player) {
        MetaBlock block = new MetaBlock(world, x, y, z);
        if (block.equals(pointed)) {
            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y, z, result.getBlock(), result.getMeta());
            if (world.field_73012_v.nextInt(8) == 0) {
                PacketHandler.sendToAllAround(new ParticlePKT("largesmoke", x, y + 1, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)(y + 1), (double)z, 32.0));
            }
        }
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        if (!world.field_72995_K) {
            player.func_71064_a((StatBase)AchievementHandler.PHIL_STONE, 1);
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
        world.func_72838_d((Entity)new EntityMobRandomizer(world, player));
        return true;
    }

    @Override
    public void doExtraFunction(ItemStack stack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui((Object)PECore.instance, 13, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.philstone.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)));
        list.add(StatCollector.func_74838_a((String)"pe.philstone.tooltip2"));
        list.add(StatCollector.func_74838_a((String)"pe.philstone.tooltip3"));
        list.add(StatCollector.func_74838_a((String)"pe.philstone.tooltip4"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("philosophers_stone"));
    }
}

