/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayer;

public final class PlayerTimers {
    private static final LinkedHashMap<String, TimerSet> MAP = Maps.newLinkedHashMap();

    public static void update() {
        for (TimerSet timers : MAP.values()) {
            if (timers.repair.shouldUpdate) {
                if (timers.repair.tickCount < 19) {
                    timers.repair.tickCount = (short)(timers.repair.tickCount + 1);
                }
                timers.repair.shouldUpdate = false;
            }
            if (timers.heal.shouldUpdate) {
                if (timers.heal.tickCount < 19) {
                    timers.heal.tickCount = (short)(timers.heal.tickCount + 1);
                }
                timers.heal.shouldUpdate = false;
            }
            if (!timers.feed.shouldUpdate) continue;
            if (timers.feed.tickCount < 19) {
                timers.feed.tickCount = (short)(timers.feed.tickCount + 1);
            }
            timers.feed.shouldUpdate = false;
        }
    }

    public static void registerPlayer(EntityPlayer player) {
        MAP.put(player.func_70005_c_(), new TimerSet());
    }

    public static void removePlayer(EntityPlayer player) {
        MAP.remove(player.func_70005_c_());
    }

    public static void activateRepair(EntityPlayer player) {
        PlayerTimers.MAP.get((Object)player.func_70005_c_()).repair.shouldUpdate = true;
    }

    public static void activateHeal(EntityPlayer player) {
        PlayerTimers.MAP.get((Object)player.func_70005_c_()).heal.shouldUpdate = true;
    }

    public static void activateFeed(EntityPlayer player) {
        PlayerTimers.MAP.get((Object)player.func_70005_c_()).feed.shouldUpdate = true;
    }

    public static boolean canRepair(EntityPlayer player) {
        Timer timer = PlayerTimers.MAP.get((Object)player.func_70005_c_()).repair;
        if (timer.tickCount >= 19) {
            timer.tickCount = 0;
            timer.shouldUpdate = false;
            return true;
        }
        return false;
    }

    public static boolean canHeal(EntityPlayer player) {
        Timer timer = PlayerTimers.MAP.get((Object)player.func_70005_c_()).heal;
        if (timer.tickCount >= 19) {
            timer.tickCount = 0;
            timer.shouldUpdate = false;
            return true;
        }
        return false;
    }

    public static boolean canFeed(EntityPlayer player) {
        Timer timer = PlayerTimers.MAP.get((Object)player.func_70005_c_()).feed;
        if (timer.tickCount >= 19) {
            timer.tickCount = 0;
            timer.shouldUpdate = false;
            return true;
        }
        return false;
    }

    private static class Timer {
        public short tickCount = 0;
        public boolean shouldUpdate = false;

        public String toString() {
            return "TICKS: " + this.tickCount + "\n" + "ACTIVE: " + this.shouldUpdate;
        }
    }

    private static class TimerSet {
        public Timer repair = new Timer();
        public Timer heal = new Timer();
        public Timer feed = new Timer();
    }
}

