/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import moze_intel.projecte.playerData.AlchemicalBags;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class IOHandler {
    private static File knowledgeFile;
    private static File bagDataFile;

    public static void init(File knowledge, File bagData) {
        if (!knowledge.exists() || !bagData.exists()) {
            return;
        }
        knowledgeFile = knowledge;
        bagDataFile = bagData;
        IOHandler.readLegacyData();
    }

    private static void readLegacyData() {
        NBTTagList list;
        NBTTagCompound knowledge = null;
        try {
            knowledge = CompressedStreamTools.func_74797_a((File)knowledgeFile);
        }
        catch (IOException e) {
            PELogger.logFatal("Error loading legacy knowledge file");
        }
        if (knowledge != null) {
            NBTTagList tomeKnowledge = knowledge.func_150295_c("Tome Knowledge", 10);
            for (int i = 0; i < tomeKnowledge.func_74745_c(); ++i) {
                NBTTagCompound tag = tomeKnowledge.func_150305_b(i);
                String username = tag.func_74779_i("player");
                if (username.isEmpty()) continue;
                Transmutation.legacySetAllKnowledge(username);
            }
            list = knowledge.func_150295_c("knowledge", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound subTag = list.func_150305_b(i);
                LinkedList<ItemStack> stackList = new LinkedList<ItemStack>();
                NBTTagList subList = subTag.func_150295_c("data", 10);
                for (int j = 0; j < subList.func_74745_c(); ++j) {
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)subList.func_150305_b(j));
                    if (stack == null) continue;
                    stackList.add(stack);
                }
                Transmutation.legacySetKnowledge(subTag.func_74779_i("player"), stackList);
            }
            NBTTagList emc = knowledge.func_150295_c("playerEMC", 10);
            for (int i = 0; i < emc.func_74745_c(); ++i) {
                NBTTagCompound tag = emc.func_150305_b(i);
                Transmutation.legacySetStoredEmc(tag.func_74779_i("player"), tag.func_74769_h("emc"));
            }
            PELogger.logDebug("** LOADED LEGACY TRANSMUTATION DATA **");
        }
        NBTTagCompound bagData = null;
        try {
            bagData = CompressedStreamTools.func_74797_a((File)bagDataFile);
        }
        catch (Exception e) {
            PELogger.logFatal("Error loading legacy bag file");
        }
        if (bagData != null) {
            list = bagData.func_150295_c("bagdata", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                NBTTagList subList = nbt.func_150295_c("data", 10);
                for (int j = 0; j < subList.func_74745_c(); ++j) {
                    NBTTagCompound subNbt = subList.func_150305_b(j);
                    ItemStack[] inv = new ItemStack[104];
                    NBTTagList subList2 = subNbt.func_150295_c("inv", 10);
                    for (int k = 0; k < subList2.func_74745_c(); ++k) {
                        NBTTagCompound subNbt2 = subList2.func_150305_b(k);
                        inv[subNbt2.func_74771_c((String)"index")] = ItemStack.func_77949_a((NBTTagCompound)subNbt2);
                    }
                    AlchemicalBags.legacySet(nbt.func_74779_i("player"), subNbt.func_74771_c("color"), inv);
                }
            }
            PELogger.logDebug("** LOADED LEGACY BAG DATA **");
        }
    }
}

