/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.IvMultiBlockHelper;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import org.lwjgl.util.vector.Vector3f;

public class IvTileEntityMultiBlock
extends TileEntity {
    public int[] parentCoords;
    public int[][] childCoords;
    public int direction;
    public double[] centerCoords = new double[]{0.5, 0.5, 0.5};
    public double[] centerCoordsSize = new double[]{0.5, 0.5, 0.5};
    public boolean multiblockInvalid;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isParent()) {
            this.updateEntityParent();
        } else {
            this.updateEntityChild();
        }
    }

    public void updateEntityParent() {
    }

    public void updateEntityChild() {
    }

    public int[] getActiveParentCoords() {
        if (this.parentCoords == null) {
            return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
        }
        return new int[]{this.field_145851_c + this.parentCoords[0], this.field_145848_d + this.parentCoords[1], this.field_145849_e + this.parentCoords[2]};
    }

    public int[][] getActiveChildCoords() {
        if (this.childCoords == null) {
            return new int[0][0];
        }
        int[][] returnInt = new int[this.childCoords.length][3];
        for (int i = 0; i < returnInt.length; ++i) {
            returnInt[i][0] = this.childCoords[i][0] + this.field_145851_c;
            returnInt[i][1] = this.childCoords[i][1] + this.field_145848_d;
            returnInt[i][2] = this.childCoords[i][2] + this.field_145849_e;
        }
        return returnInt;
    }

    public double[] getActiveCenterCoords() {
        if (this.centerCoords == null) {
            return new double[]{(double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5};
        }
        return new double[]{(double)this.field_145851_c + this.centerCoords[0], (double)this.field_145848_d + this.centerCoords[1], (double)this.field_145849_e + this.centerCoords[2]};
    }

    public void becomeChild(TileEntity parent) {
        this.parentCoords = (int[])(parent != null ? new int[]{parent.field_145851_c - this.field_145851_c, parent.field_145848_d - this.field_145848_d, parent.field_145849_e - this.field_145849_e} : null);
    }

    public void becomeParent(List<int[]> childCoords) {
        if (childCoords != null) {
            this.childCoords = new int[childCoords.size()][3];
            for (int i = 0; i < childCoords.size(); ++i) {
                int[] location = childCoords.get(i);
                this.childCoords[i][0] = location[0] - this.field_145851_c;
                this.childCoords[i][1] = location[1] - this.field_145848_d;
                this.childCoords[i][2] = location[2] - this.field_145849_e;
            }
        } else {
            this.childCoords = new int[0][0];
        }
    }

    public boolean isParent() {
        return this.parentCoords == null;
    }

    public IvTileEntityMultiBlock getTotalParent() {
        return this.isParent() ? this : this.getParent();
    }

    public IvTileEntityMultiBlock getParent() {
        if (this.parentCoords != null) {
            int[] parentCoords = this.getActiveParentCoords();
            TileEntity parentTileEntity = this.func_145831_w().func_147438_o(parentCoords[0], parentCoords[1], parentCoords[2]);
            if (parentTileEntity != null && ((Object)((Object)this)).getClass().equals(parentTileEntity.getClass())) {
                return (IvTileEntityMultiBlock)parentTileEntity;
            }
        }
        return null;
    }

    public float getDistanceToCenter() {
        return (float)IvVecMathHelper.distance(new double[]{(double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5}, this.getActiveCenterCoords());
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.direction = par1nbtTagCompound.func_74762_e("direction");
        this.centerCoords = IvNBTHelper.readDoubleArray("multiBlockCenter", par1nbtTagCompound);
        if (this.centerCoords == null) {
            this.centerCoords = new double[3];
            this.centerCoords[0] = par1nbtTagCompound.func_74764_b("centerCoords[0]") ? par1nbtTagCompound.func_74769_h("centerCoords[0]") - (double)this.field_145851_c : 0.5;
            this.centerCoords[1] = par1nbtTagCompound.func_74764_b("centerCoords[1]") ? par1nbtTagCompound.func_74769_h("centerCoords[1]") - (double)this.field_145848_d : 0.5;
            this.centerCoords[2] = par1nbtTagCompound.func_74764_b("centerCoords[2]") ? par1nbtTagCompound.func_74769_h("centerCoords[2]") - (double)this.field_145849_e : 0.5;
        }
        this.centerCoordsSize = IvNBTHelper.readDoubleArray("multiBlockSize", par1nbtTagCompound);
        if (this.centerCoordsSize == null) {
            this.centerCoordsSize = new double[3];
            this.centerCoordsSize[0] = par1nbtTagCompound.func_74764_b("centerCoordsSize[0]") ? (double)par1nbtTagCompound.func_74760_g("centerCoordsSize[0]") : 0.5;
            this.centerCoordsSize[1] = par1nbtTagCompound.func_74764_b("centerCoordsSize[1]") ? (double)par1nbtTagCompound.func_74760_g("centerCoordsSize[1]") : 0.5;
            this.centerCoordsSize[2] = par1nbtTagCompound.func_74764_b("centerCoordsSize[2]") ? (double)par1nbtTagCompound.func_74760_g("centerCoordsSize[2]") : 0.5;
        }
        this.parentCoords = (int[])(par1nbtTagCompound.func_74764_b("parentCoords") ? IvNBTHelper.readIntArrayFixedSize("parentCoords", 3, par1nbtTagCompound) : null);
        if (par1nbtTagCompound.func_74764_b("childCoords")) {
            int[] childCoordsCut = par1nbtTagCompound.func_74759_k("childCoords");
            this.childCoords = new int[childCoordsCut.length / 3][3];
            for (int i = 0; i < this.childCoords.length; ++i) {
                this.childCoords[i][0] = childCoordsCut[i * 3];
                this.childCoords[i][1] = childCoordsCut[i * 3 + 1];
                this.childCoords[i][2] = childCoordsCut[i * 3 + 2];
            }
        } else if (this.parentCoords == null) {
            this.childCoords = new int[0][0];
        }
        this.multiblockInvalid = par1nbtTagCompound.func_74767_n("multiblockInvalid");
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("direction", this.direction);
        IvNBTHelper.writeDoubleArray("multiBlockCenter", this.centerCoords, par1nbtTagCompound);
        IvNBTHelper.writeDoubleArray("multiBlockSize", this.centerCoordsSize, par1nbtTagCompound);
        if (this.parentCoords != null) {
            par1nbtTagCompound.func_74783_a("parentCoords", this.parentCoords);
        }
        if (this.childCoords != null) {
            int[] childCoordsCut = new int[this.childCoords.length * 3];
            for (int i = 0; i < this.childCoords.length; ++i) {
                childCoordsCut[i * 3] = this.childCoords[i][0];
                childCoordsCut[i * 3 + 1] = this.childCoords[i][1];
                childCoordsCut[i * 3 + 2] = this.childCoords[i][2];
            }
            par1nbtTagCompound.func_74783_a("childCoords", childCoordsCut);
        }
    }

    public Packet func_145844_m() {
        return IvTileEntityHelper.getStandardDescriptionPacket(this);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public IvRaytraceableAxisAlignedBox getInterpolatedRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth, double x1, double y1, double z1, double width1, double height1, double depth1, float fraction) {
        double xI = IvMathHelper.mix(x, x1, (double)fraction);
        double yI = IvMathHelper.mix(y, y1, (double)fraction);
        double zI = IvMathHelper.mix(z, z1, (double)fraction);
        double wI = IvMathHelper.mix(width, width1, (double)fraction);
        double hI = IvMathHelper.mix(height, height1, (double)fraction);
        double dI = IvMathHelper.mix(depth, depth1, (double)fraction);
        return this.getRotatedBox(userInfo, xI, yI, zI, wI, hI, dI);
    }

    public IvRaytraceableAxisAlignedBox getRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth) {
        return IvMultiBlockHelper.getRotatedBox(userInfo, x, y, z, width, height, depth, this.getDirection(), this.getActiveCenterCoords());
    }

    public AxisAlignedBB getRotatedBB(double x, double y, double z, double width, double height, double depth) {
        return IvMultiBlockHelper.getRotatedBB(x, y, z, width, height, depth, this.getDirection(), this.getActiveCenterCoords());
    }

    public Vector3f getRotatedVector(Vector3f vector3f) {
        return IvMultiBlockHelper.getRotatedVector(vector3f, this.getDirection());
    }

    public Vec3 getRotatedVector(Vec3 vec3) {
        return IvMultiBlockHelper.getRotatedVector(vec3, this.getDirection());
    }

    public int getDirection() {
        return this.direction;
    }

    public AxisAlignedBB getBoxAroundCenter(double width, double height, double length) {
        double[] center = this.getActiveCenterCoords();
        return AxisAlignedBB.func_72330_a((double)(center[0] - width), (double)(center[1] - height), (double)(center[2] - length), (double)(center[0] + width), (double)(center[1] + height), (double)(center[2] + length));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isParent()) {
            return this.getBoxAroundCenter(0.0, 0.0, 0.0);
        }
        return this.getBoxAroundCenter(this.centerCoordsSize[0], this.centerCoordsSize[1], this.centerCoordsSize[2]);
    }
}

