/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.classic;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.classic.Maze;
import ivorius.ivtoolkit.maze.classic.MazeCoordinateDirect;
import ivorius.ivtoolkit.maze.classic.MazeCoordinates;
import ivorius.ivtoolkit.maze.classic.MazePath;
import ivorius.ivtoolkit.maze.classic.MazeRoom;
import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class MazeGenerator {
    public static <T> void blockRoomAndExits(Maze<T> maze, MazeRoom coordinate, T room, T blockedPath) {
        maze.set(room, coordinate);
        for (MazePath neighbor : MazeCoordinates.getNeighborPaths(coordinate)) {
            maze.replace(maze.nullValue, blockedPath, neighbor);
        }
    }

    public static <T> void generateStartPathsForEnclosedMaze(Maze<T> maze, Iterable<MazePath> startPoints, Iterable<MazeRoom> blockedRooms, AxisAlignedTransform2D transform, T path, T room, T blockedPath) {
        int[] mazeSizeInRooms = new int[maze.dimensions.length];
        for (int i = 0; i < mazeSizeInRooms.length; ++i) {
            mazeSizeInRooms[i] = (maze.dimensions[i] - 1) / 2;
        }
        for (MazePath exitPath : maze.allPaths()) {
            if (!maze.isPathPointingOutside(exitPath)) continue;
            maze.set(blockedPath, exitPath);
        }
        for (MazeRoom blockedRoom : blockedRooms) {
            blockedRoom = MazeCoordinates.rotatedRoom(blockedRoom, transform, mazeSizeInRooms);
            MazeGenerator.blockRoomAndExits(maze, blockedRoom, room, blockedPath);
        }
        for (MazePath startPoint : startPoints) {
            maze.set(path, MazeCoordinates.rotatedPath(startPoint, transform, mazeSizeInRooms));
        }
    }

    public static <T> MazePath randomEmptyPathInMaze(Random rand, Maze<T> maze, Collection<Integer> applicableDimensions) {
        ArrayList paths = Lists.newArrayList(maze.allPaths());
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            MazePath path = (MazePath)iterator.next();
            if (maze.isNull(maze.get(path)) && applicableDimensions.contains(path.getPathDimension())) continue;
            iterator.remove();
        }
        if (paths.size() > 0) {
            return (MazePath)paths.get(rand.nextInt(paths.size()));
        }
        return null;
    }

    @Deprecated
    public static MazeRoom randomRoomInMaze(Random rand, Maze maze, int ... distanceFromOutside) {
        int[] position = new int[maze.dimensions.length];
        for (int i = 0; i < maze.dimensions.length; ++i) {
            position[i] = rand.nextInt(maze.dimensions[i] / 2 - distanceFromOutside[i]);
        }
        return new MazeRoom(position);
    }

    @Deprecated
    public static MazePath randomPathInMaze(Random rand, Maze maze, int ... distanceFromOutside) {
        ArrayList dimensionWeights = new ArrayList();
        for (int dim = 0; dim < maze.dimensions.length; ++dim) {
            int dimLength = maze.dimensions[dim] / 2 + 1 - (distanceFromOutside[dim] + 1) / 2 * 2;
            dimensionWeights.add(new WeightedSelector.SimpleItem<Integer>(Math.max(0, dimLength), dim));
        }
        int usedDimension = (Integer)WeightedSelector.select(rand, dimensionWeights);
        int[] roomDistanceFromOutside = new int[distanceFromOutside.length];
        for (int i = 0; i < roomDistanceFromOutside.length; ++i) {
            roomDistanceFromOutside[i] = distanceFromOutside[i] / 2;
        }
        MazeRoom refRoom = MazeGenerator.randomRoomInMaze(rand, maze, roomDistanceFromOutside);
        int[] pathCoord = refRoom.getMazeCoordinates();
        int availablePaths = (distanceFromOutside[usedDimension] + 1) / 2 * 2;
        pathCoord[usedDimension] = rand.nextInt(availablePaths) * 2 + (maze.dimensions[usedDimension] / 2 + 1 - availablePaths) / 2;
        return MazeCoordinates.coordToPath(new MazeCoordinateDirect(pathCoord), usedDimension);
    }
}

