/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import java.util.Map;
import javax.annotation.Nullable;

public class MazeComponents {
    public static <M extends MazeComponent<C>, C> Function<M, ShiftedMazeComponent<M, C>> shiftFunction(final MazeRoom shift) {
        return new Function<M, ShiftedMazeComponent<M, C>>(){

            @Nullable
            public ShiftedMazeComponent<M, C> apply(@Nullable M input) {
                return MazeComponents.shift(input, shift);
            }
        };
    }

    public static <M extends MazeComponent<C>, C> Function<M, Iterable<ShiftedMazeComponent<M, C>>> shiftAllFunction(final MazeRoomConnection connection, final C connector, final ConnectionStrategy<C> strategy) {
        return new Function<M, Iterable<ShiftedMazeComponent<M, C>>>(){

            @Nullable
            public Iterable<ShiftedMazeComponent<M, C>> apply(@Nullable M input) {
                ImmutableList.Builder list = ImmutableList.builder();
                if (input != null) {
                    for (Map.Entry entry : input.exits().entrySet()) {
                        MazeRoom dist = entry.getKey().distance(connection);
                        if (dist == null || !strategy.connect(connection, connector, entry.getValue())) continue;
                        list.add(MazeComponents.shift(input, dist));
                    }
                }
                return list.build();
            }
        };
    }

    public static <M extends MazeComponent<C>, C> ShiftedMazeComponent<M, C> shift(final M component, final MazeRoom shift) {
        return new ShiftedMazeComponent(component, shift, (ImmutableSet<MazeRoom>)FluentIterable.from(component.rooms()).transform((Function)new Function<MazeRoom, MazeRoom>(){

            @Nullable
            public MazeRoom apply(MazeRoom input) {
                return input != null ? input.add(shift) : null;
            }
        }).toSet(), FluentIterable.from(component.exits().keySet()).transform((Function)new Function<MazeRoomConnection, MazeRoomConnection>(){

            @Nullable
            public MazeRoomConnection apply(@Nullable MazeRoomConnection input) {
                return input != null ? input.add(shift) : null;
            }
        }).toMap(new Function<MazeRoomConnection, C>(){

            @Nullable
            public C apply(@Nullable MazeRoomConnection input) {
                return component.exits().get((Object)(input != null ? input.sub(shift) : null));
            }
        }));
    }

    public static <C> Predicate<MazeComponent<C>> compatibilityPredicate(final MazeComponent<C> component, final ConnectionStrategy<C> strategy) {
        return new Predicate<MazeComponent<C>>(){

            public boolean apply(@Nullable MazeComponent<C> input) {
                return MazeComponents.componentsCompatible(component, input, strategy);
            }
        };
    }

    public static <C> boolean componentsCompatible(MazeComponent<C> existing, MazeComponent<C> add, ConnectionStrategy<C> strategy) {
        return !MazeComponents.overlap(existing, add) && MazeComponents.allExitsCompatible(existing, add, strategy);
    }

    public static boolean overlap(MazeComponent<?> left, MazeComponent<?> right) {
        return Sets.intersection(left.rooms(), right.rooms()).size() > 0;
    }

    public static <C> boolean allExitsCompatible(final MazeComponent<C> existing, MazeComponent<C> add, final ConnectionStrategy<C> strategy) {
        return Iterables.all(add.exits().entrySet(), (Predicate)new Predicate<Map.Entry<MazeRoomConnection, C>>(){

            public boolean apply(@Nullable Map.Entry<MazeRoomConnection, C> input) {
                return input == null || strategy.connect(input.getKey(), existing.exits().get((Object)input.getKey()), input.getValue());
            }
        });
    }
}

