/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModItemFilter
implements IItemFilter {
    private final String[] mods = new String[3];

    public String setMod(int index, ItemStack itemStack) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        if (itemStack == null || itemStack.func_77973_b() == null) {
            this.setMod(index, (String)null);
            return null;
        }
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        if (ui == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = ui.modId;
        if (targetMod == null) {
            this.setMod(index, (String)null);
            return null;
        }
        this.setMod(index, targetMod);
        return targetMod;
    }

    public void setMod(int index, String mod) {
        if (index < 0 || index >= this.mods.length) {
            return;
        }
        this.mods[index] = mod;
    }

    public String getModAt(int index) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        return this.mods[index];
    }

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b());
        if (ui == null) {
            return false;
        }
        String targetMod = ui.modId;
        if (targetMod == null) {
            return false;
        }
        for (String mod : this.mods) {
            if (!targetMod.equals(mod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        return false;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<Slot> getSlots(int xOffset, int yOffset) {
        return Collections.emptyList();
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = nbtRoot.func_74779_i("mod" + i);
            this.mods[i] = mod == null || mod.isEmpty() || "-".equals(mod) ? null : mod;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = this.mods[i];
            if (mod == null || mod.trim().isEmpty()) {
                nbtRoot.func_74778_a("mod" + i, "-");
                continue;
            }
            nbtRoot.func_74778_a("mod" + i, mod);
        }
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound(root, buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound(buf);
        this.readFromNBT(tag);
    }
}

