/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    private final Set<Signal> signals = new HashSet<Signal>();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class);
    }

    @Override
    public Class<IRedstoneConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void init(IConduitBundle tile, Collection<IRedstoneConduit> connections, World world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignals();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
        }
        ArrayList<Signal> copy = new ArrayList<Signal>(this.signals);
        this.signals.clear();
        for (Signal s : copy) {
            this.notifyNeigborsOfSignalUpdate(s);
        }
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(IRedstoneConduit con) {
        this.updatingNetwork = true;
        super.addConduit(con);
        Set<Signal> newInputs = con.getNetworkInputs();
        this.signals.addAll(newInputs);
        for (Signal signal : newInputs) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
        for (Signal signal : this.signals) {
            this.notifyConduitNeighbours(con, signal);
        }
        this.updatingNetwork = false;
    }

    public Set<Signal> getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return Collections.emptySet();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    public void addSignals(Set<Signal> newSignals) {
        for (Signal signal : newSignals) {
            this.addSignal(signal);
        }
    }

    public void addSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.add(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void removeSignals(Set<Signal> remove) {
        for (Signal signal : remove) {
            this.removeSignal(signal);
        }
    }

    public void removeSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.remove(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void replaceSignal(Signal oldSig, Signal newSig) {
        this.updatingNetwork = true;
        this.signals.remove(oldSig);
        this.signals.add(newSig);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(newSig);
        this.updatingNetwork = false;
    }

    @Override
    public void notifyNetworkOfUpdate() {
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(!this.getSignals().isEmpty());
        }
        super.notifyNetworkOfUpdate();
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<");
            sb.append(te.field_145851_c + "," + te.field_145848_d + "," + te.field_145849_e);
            sb.append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignals() {
        for (Signal signal : this.signals) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
    }

    public void notifyNeigborsOfSignalUpdate(Signal signal) {
        ArrayList conduitsCopy = new ArrayList(this.conduits);
        for (IRedstoneConduit con : conduitsCopy) {
            this.notifyConduitNeighbours(con, signal);
        }
    }

    private void notifyConduitNeighbours(IRedstoneConduit con, Signal signal) {
        if (con.getBundle() == null) {
            System.out.println("RedstoneConduitNetwork.notifyNeigborsOfSignalUpdate: NULL BUNDLE!!!!");
            return;
        }
        TileEntity te = con.getBundle().getEntity();
        World worldObj = te.func_145831_w();
        worldObj.func_147459_d(te.field_145851_c, te.field_145848_d, te.field_145849_e, (Block)EnderIO.blockConduitBundle);
        if (signal != null) {
            if (worldObj.func_147439_a(te.field_145851_c + 1, te.field_145848_d, te.field_145849_e).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c + 1, te.field_145848_d, te.field_145849_e, (Block)EnderIO.blockConduitBundle);
            }
            if (worldObj.func_147439_a(te.field_145851_c - 1, te.field_145848_d, te.field_145849_e).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c - 1, te.field_145848_d, te.field_145849_e, (Block)EnderIO.blockConduitBundle);
            }
            if (worldObj.func_147439_a(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e, (Block)EnderIO.blockConduitBundle);
            }
            if (worldObj.func_147439_a(te.field_145851_c, te.field_145848_d - 1, te.field_145849_e).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c, te.field_145848_d - 1, te.field_145849_e, (Block)EnderIO.blockConduitBundle);
            }
            if (worldObj.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e + 1).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c, te.field_145848_d, te.field_145849_e + 1, (Block)EnderIO.blockConduitBundle);
            }
            if (worldObj.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e - 1).func_149721_r()) {
                worldObj.func_147459_d(te.field_145851_c, te.field_145848_d, te.field_145849_e - 1, (Block)EnderIO.blockConduitBundle);
            }
        }
    }
}

