/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private Map<Block, Item> buckets = new HashMap<Block, Item>();

    private BucketHandler() {
    }

    public void registerFluid(Block fluidBlock, Item fullBucket) {
        this.buckets.put(fluidBlock, fullBucket);
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack res = this.getFilledBucket(event.world, event.target);
        if (res != null) {
            event.result = res;
            event.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack getFilledBucket(World world, MovingObjectPosition pos) {
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Item bucket = this.buckets.get(block);
        if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return new ItemStack(bucket);
        }
        return null;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

