/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.zombie.NutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketZombieTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDistributor;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import crazypants.util.ITankAccess;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileZombieGenerator
extends AbstractGeneratorEntity
implements IFluidHandler,
ITankAccess {
    private static int IO_MB_TICK = 250;
    final NutrientTank fuelTank = new NutrientTank(2000);
    int outputPerTick = Config.zombieGeneratorRfPerTick;
    int tickPerBucketOfFuel = Config.zombieGeneratorTicksPerBucketFuel;
    private boolean tanksDirty;
    private boolean active = false;
    private PowerDistributor powerDis;
    private int ticksRemaingFuel;
    private boolean inPause;
    int pass = 0;

    public TileZombieGenerator() {
        super(new SlotDefinition(0, 0, 0));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockZombieGenerator.unlocalisedName;
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        FluidTankInfo[] infos;
        boolean res = super.doPull(dir);
        BlockCoord loc = this.getLocation().getLocation(dir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc);
        if (target != null && (infos = target.getTankInfo(dir.getOpposite())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = this.fill(dir, drained, false)) <= 0) continue;
                drained = target.drain(dir.getOpposite(), filled, true);
                this.fill(dir, drained, true);
                return res;
            }
        }
        return res;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.outputPerTick;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = false;
        if (!redstoneCheckPassed) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (this.getEnergyStored() >= this.capacitorType.capacitor.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround(new PacketZombieTank(this), this);
            this.tanksDirty = false;
        }
        return res;
    }

    private boolean generateEnergy() {
        boolean generated = false;
        if (this.inPause && this.getEnergyStored() >= this.getMaxEnergyStored() - this.outputPerTick * 200) {
            return false;
        }
        this.inPause = false;
        if ((float)this.fuelTank.getFluidAmount() < (float)this.fuelTank.getCapacity() * 0.7f) {
            return false;
        }
        --this.ticksRemaingFuel;
        if (this.ticksRemaingFuel <= 0) {
            this.fuelTank.drain(1, true);
            this.ticksRemaingFuel = this.tickPerBucketOfFuel / 1000;
            this.tanksDirty = true;
        }
        this.setEnergyStored(this.getEnergyStored() + this.outputPerTick);
        return true;
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord(this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.outputPerTick * 2, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int res = this.fuelTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.getID() == EnderIO.fluidNutrientDistillation.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fuelTank.getInfo()};
    }

    public int getFluidStored(ForgeDirection from) {
        return this.fuelTank.getFluidAmount();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.active = nbtRoot.func_74767_n("active");
    }

    public boolean shouldRenderInPass(int pass) {
        this.pass = pass;
        if (pass == 0) {
            return true;
        }
        if (pass == 1) {
            return this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        if (nbtRoot.func_74764_b("fuelTank")) {
            NBTTagCompound tankRoot = (NBTTagCompound)nbtRoot.func_74781_a("fuelTank");
            if (tankRoot != null) {
                this.fuelTank.readFromNBT(tankRoot);
            } else {
                this.fuelTank.setFluid(null);
            }
        } else {
            this.fuelTank.setFluid(null);
        }
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        if (this.fuelTank.getFluidAmount() > 0) {
            NBTTagCompound tankRoot = new NBTTagCompound();
            this.fuelTank.writeToNBT(tankRoot);
            nbtRoot.func_74782_a("fuelTank", (NBTBase)tankRoot);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.func_74757_a("active", this.active);
    }

    @Override
    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == EnderIO.fluidNutrientDistillation) {
            return this.fuelTank;
        }
        return null;
    }

    @Override
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    @Override
    public void setTanksDirty() {
        this.tanksDirty = true;
    }
}

