/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AbstractMachineContainer
extends Container {
    protected final AbstractMachineEntity tileEntity;
    protected Map<Slot, Point> playerSlotLocations = new HashMap<Slot, Point>();
    protected Slot upgradeSlot;

    public AbstractMachineContainer(InventoryPlayer playerInv, AbstractMachineEntity te) {
        int i;
        this.tileEntity = te;
        this.addMachineSlots(playerInv);
        if (te.getSlotDefinition().getNumUpgradeSlots() == 1) {
            this.upgradeSlot = new Slot((IInventory)te, te.getSlotDefinition().getMinUpgradeSlot(), this.getUpgradeOffset().x, this.getUpgradeOffset().y){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack itemStack) {
                    return AbstractMachineContainer.this.tileEntity.func_94041_b(AbstractMachineContainer.this.tileEntity.getSlotDefinition().getMinUpgradeSlot(), itemStack);
                }
            };
            this.func_75146_a(this.upgradeSlot);
        }
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Point loc = new Point(x + j * 18, y + i * 18);
                Slot slot = new Slot((IInventory)playerInv, j + i * 9 + 9, loc.x, loc.y);
                this.func_75146_a(slot);
                this.playerSlotLocations.put(slot, loc);
            }
        }
        for (i = 0; i < 9; ++i) {
            Point loc = new Point(x + i * 18, y + 58);
            Slot slot = new Slot((IInventory)playerInv, i, loc.x, loc.y);
            this.func_75146_a(slot);
            this.playerSlotLocations.put(slot, loc);
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.tileEntity.func_70300_a(entityplayer);
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    public Slot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public AbstractMachineEntity getTileEntity() {
        return this.tileEntity;
    }

    protected abstract void addMachineSlots(InventoryPlayer var1);

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        SlotDefinition slotDef = this.tileEntity.getSlotDefinition();
        int startPlayerSlot = this.getIndexOfFirstPlayerInvSlot(slotDef);
        int endPlayerSlot = startPlayerSlot + 26;
        int startHotBarSlot = endPlayerSlot + 1;
        int endHotBarSlot = startHotBarSlot + 9;
        ItemStack copystack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copystack = origStack.func_77946_l();
            if (slotDef.isInputSlot(slotIndex) || slotDef.isUpgradeSlot(slotIndex)) {
                if (!this.func_75135_a(origStack, startPlayerSlot, endHotBarSlot, false)) {
                    return null;
                }
            } else if (slotDef.isOutputSlot(slotIndex)) {
                if (!this.func_75135_a(origStack, startPlayerSlot, endHotBarSlot, true)) {
                    return null;
                }
                slot.func_75220_a(origStack, copystack);
            } else if (!(slotIndex < startPlayerSlot || slotDef.getNumInputSlots() > 0 && this.func_75135_a(origStack, slotDef.getMinInputSlot(), slotDef.getMaxInputSlot() + 1, false) || slotDef.getNumUpgradeSlots() > 0 && this.func_75135_a(origStack, slotDef.getMinUpgradeSlot(), slotDef.getMaxUpgradeSlot() + 1, false) || !(slotIndex <= endPlayerSlot ? !this.func_75135_a(origStack, startHotBarSlot, endHotBarSlot, false) : slotIndex >= startHotBarSlot && slotIndex <= endHotBarSlot && !this.func_75135_a(origStack, startPlayerSlot, endPlayerSlot, false)))) {
                return null;
            }
            if (origStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            slot.func_75218_e();
            if (origStack.field_77994_a == copystack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityPlayer, origStack);
        }
        return copystack;
    }

    protected int getIndexOfFirstPlayerInvSlot(SlotDefinition slotDef) {
        return slotDef.getNumSlots();
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (par1ItemStack.field_77994_a > 0 && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    int mergedSize = itemstack1.field_77994_a + par1ItemStack.field_77994_a;
                    int maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a());
                    if (mergedSize <= maxStackSize) {
                        par1ItemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = mergedSize;
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.field_77994_a < maxStackSize) {
                        par1ItemStack.field_77994_a -= maxStackSize - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = maxStackSize;
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (par1ItemStack.field_77994_a > 0) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    in.field_77994_a = Math.min(in.field_77994_a, slot.func_75219_a());
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    par1ItemStack.field_77994_a = in.field_77994_a >= par1ItemStack.field_77994_a ? 0 : (par1ItemStack.field_77994_a -= in.field_77994_a);
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }
}

