/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.enderio.machine.wireless.WirelessChargerController;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class WirelessChargedLocation {
    private final TileEntity te;
    private int lastChangeCount;
    private final List<IWirelessCharger> chargers;

    public WirelessChargedLocation(TileEntity te) {
        this.te = te;
        this.chargers = new ArrayList<IWirelessCharger>();
        this.updateChargers();
    }

    private void updateChargers() {
        WirelessChargerController wcc = WirelessChargerController.instance;
        this.chargers.clear();
        this.lastChangeCount = wcc.getChangeCount();
        wcc.getChargers(this.te.func_145831_w(), new BlockCoord(this.te), this.chargers);
    }

    public boolean chargeItems(ItemStack[] items) {
        if (this.lastChangeCount != WirelessChargerController.instance.getChangeCount()) {
            this.updateChargers();
        }
        for (IWirelessCharger wc : this.chargers) {
            if (!wc.isActive() || !wc.chargeItems(items)) continue;
            return true;
        }
        return false;
    }
}

