/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import dmillerw.tml.data.NBTDeserializer;
import dmillerw.tml.data.NBTSerializer;
import net.minecraft.nbt.NBTTagCompound;

public class GsonHelper {
    public static Gson gson;

    public static Number parseNumber(char type, JsonPrimitive jsonPrimitive) {
        String string = jsonPrimitive.getAsString();
        string = string.substring(0, string.length() - 1);
        if ((type == 'b' || type == 'B' || type == 'i' || type == 'I' || type == 's' || type == 'S' || type == 'l' || type == 'L') && string.contains(".")) {
            string = string.substring(0, string.indexOf("."));
        }
        if (type == 'b' || type == 'B') {
            return Byte.parseByte(string);
        }
        if (type == 's' || type == 'S') {
            return Short.parseShort(string);
        }
        if (type == 'i' || type == 'I') {
            return Integer.parseInt(string);
        }
        if (type == 'f' || type == 'F') {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (type == 'd' || type == 'D') {
            return Double.parseDouble(string);
        }
        if (type == 'l' || type == 'L') {
            return Long.parseLong(string);
        }
        return null;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(NBTTagCompound.class, (Object)new NBTDeserializer());
        builder.registerTypeAdapter(NBTTagCompound.class, (Object)new NBTSerializer());
        builder.setPrettyPrinting();
        gson = builder.create();
    }
}

