/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;

public class SpecialMobData {
    private static final float RANDOM_SCALING = (float)Properties.getDouble("_general", "random_scaling");
    private static final byte SCALE = 21;
    private EntityLiving theEntity;
    private ResourceLocation[] textures;
    private byte healTime;
    private byte healTimeMax;

    public SpecialMobData(EntityLiving entity, ResourceLocation ... baseTextures) {
        this.theEntity = entity;
        this.textures = baseTextures;
        this.theEntity.func_70096_w().func_75682_a(21, (Object)Float.valueOf(RANDOM_SCALING > 0.0f ? 1.0f + (entity.func_70681_au().nextFloat() - 0.5f) * RANDOM_SCALING : 1.0f));
    }

    public void onUpdate() {
        if (this.healTimeMax > 0 && (this.healTime = (byte)(this.healTime + 1)) >= this.healTimeMax) {
            this.healTime = 0;
            this.theEntity.func_70691_i(1.0f);
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data, EntityLiving proxy) {
        NBTTagCompound entityData = new NBTTagCompound();
        this.theEntity.func_70109_d(entityData);
        proxy.func_70020_e(entityData);
        data = proxy.func_110161_a(data);
        entityData = new NBTTagCompound();
        proxy.func_70109_d(entityData);
        this.theEntity.func_70020_e(entityData);
        ((ISpecialMob)this.theEntity).adjustEntityAttributes();
        if (proxy.field_70153_n != null) {
            proxy.field_70153_n.func_70078_a((Entity)this.theEntity);
        }
        this.theEntity.func_70078_a(proxy.field_70154_o);
        return data;
    }

    public void addAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() + amount);
    }

    public void multAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() * amount);
    }

    public void setHealTime(int time) {
        this.healTimeMax = (byte)time;
    }

    public int getTextureCount() {
        return this.textures.length;
    }

    public ResourceLocation getTexture() {
        return this.textures[0];
    }

    public ResourceLocation getTexture(int index) {
        return this.textures[index];
    }

    public void setTextures(ResourceLocation ... tex) {
        this.textures = tex;
    }

    public float getRenderScale() {
        return this.theEntity.func_70096_w().func_111145_d(21);
    }

    public void setRenderScale(float scale) {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            this.theEntity.func_70096_w().func_75692_b(21, (Object)Float.valueOf(scale));
        }
    }

    public void resetRenderScale(float scale) {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            this.theEntity.func_70096_w().func_75692_b(21, (Object)Float.valueOf(RANDOM_SCALING > 0.0f ? scale + (this.theEntity.func_70681_au().nextFloat() - 0.5f) * RANDOM_SCALING : scale));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a("SMScale", this.getRenderScale());
        tag.func_74774_a("SMRegen", this.healTimeMax);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("SMScale")) {
            this.setRenderScale(tag.func_74760_g("SMScale"));
        }
        if (tag.func_74764_b("SMRegen")) {
            this.setHealTime(tag.func_74771_c("SMRegen"));
        }
    }
}

