/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.cavespider;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialCaveSpider
extends EntityCaveSpider
implements ISpecialMob {
    private static final double HOSTILE_CHANCE = Properties.getDouble("_mob_stats", "hostile_cavespiders");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/spider/cave_spider.png"), new ResourceLocation("textures/entity/spider_eyes.png")};
    public boolean isHostile;
    public boolean fakeDarkness;
    private final SpecialMobData specialData = new SpecialMobData((EntityLiving)this, TEXTURES);

    public Entity_SpecialCaveSpider(World world) {
        super(world);
        this.getSpecialData().resetRenderScale(0.7f);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        if (this.field_70146_Z.nextDouble() < HOSTILE_CHANCE) {
            this.isHostile = true;
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    protected void func_70626_be() {
        EntityPlayer player;
        super.func_70626_be();
        if (this.isHostile && !this.func_70781_l() && (player = this.field_70170_p.func_72890_a((Entity)this, 100.0)) != null) {
            this.func_70625_a((Entity)player, 100.0f, 100.0f);
        }
    }

    protected Entity func_70782_k() {
        if (this.isHostile) {
            this.fakeDarkness = true;
        }
        return super.func_70782_k();
    }

    protected void func_70785_a(Entity target, float distance) {
        if (this.isHostile) {
            this.fakeDarkness = true;
        }
        super.func_70785_a(target, distance);
    }

    public float func_70013_c(float partialTick) {
        if (this.fakeDarkness) {
            this.fakeDarkness = false;
            return 0.0f;
        }
        return super.func_70013_c(partialTick);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityCaveSpider(this.field_70170_p));
    }

    public boolean func_70631_g_() {
        if (this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            return false;
        }
        return super.func_70631_g_();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.isHostile) {
            tag.func_74757_a("SMAnger", true);
        }
        this.getSpecialData().writeToNBT(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("SMAnger") && tag.func_74767_n("SMAnger")) {
            this.isHostile = true;
        }
        this.getSpecialData().readFromNBT(tag);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
    }
}

