/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialCreeper
extends EntityCreeper
implements ISpecialMob {
    private static final double CHARGED_CHANCE = Properties.getDouble("_mob_stats", "creeper_charge_chance");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/creeper/creeper.png")};
    public int field_70833_d;
    public int field_70834_e;
    public int field_82225_f = 30;
    public int field_82226_g = 3;
    private boolean playingDead = false;
    private final SpecialMobData specialData = new SpecialMobData((EntityLiving)this, TEXTURES);

    public Entity_SpecialCreeper(World world) {
        super(world);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        if (this.field_70170_p.func_72911_I() && this.field_70146_Z.nextDouble() < CHARGED_CHANCE) {
            this.field_70180_af.func_75692_b(17, (Object)1);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public boolean func_70089_S() {
        if (this.playingDead) {
            this.playingDead = false;
            return false;
        }
        return super.func_70089_S();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.field_70834_e = this.field_70833_d;
            int creeperState = this.func_70832_p();
            if (creeperState > 0 && this.field_70833_d == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.field_70833_d += creeperState;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                if (!this.field_70170_p.field_72995_K) {
                    this.explodeByType(this.func_70830_n(), this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.func_70106_y();
                }
            }
        }
        this.playingDead = true;
        super.func_70071_h_();
    }

    public void explodeByType(boolean powered, boolean griefing) {
        float power = powered ? (float)this.field_82226_g * 2.0f : (float)this.field_82226_g;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, griefing);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityCreeper(this.field_70170_p));
    }

    public boolean func_70631_g_() {
        if (this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            return false;
        }
        return super.func_70631_g_();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.getSpecialData().writeToNBT(tag);
        tag.func_74777_a("Fuse", (short)this.field_82225_f);
        tag.func_74774_a("ExplosionRadius", (byte)this.field_82226_g);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.getSpecialData().readFromNBT(tag);
        if (tag.func_74764_b("Fuse")) {
            this.field_82225_f = tag.func_74765_d("Fuse");
        }
        if (tag.func_74764_b("ExplosionRadius")) {
            this.field_82226_g = tag.func_74771_c("ExplosionRadius");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float partialTick) {
        return ((float)this.field_70834_e + (float)(this.field_70833_d - this.field_70834_e) * partialTick) / (float)(this.field_82225_f - 2);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
    }
}

