/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersBlock
extends BlockCoverable {
    private static float[][] bounds = new float[][]{{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f}, {0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f}, {0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f}, {0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f}};

    public BlockCarpentersBlock(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_quartered;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int data = TE.getData();
        if (++data > 6) {
            data = 0;
        }
        TE.setData(data);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int data = TE.getData();
        if (data == 0) {
            switch (EventHandler.eventFace) {
                case 0: {
                    data = 4;
                    break;
                }
                case 1: {
                    data = 3;
                    break;
                }
                case 2: {
                    data = 6;
                    break;
                }
                case 3: {
                    data = 5;
                    break;
                }
                case 4: {
                    data = 2;
                    break;
                }
                case 5: {
                    data = 1;
                }
            }
        } else {
            data = 0;
        }
        TE.setData(data);
        return true;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        int data;
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && (data = TE.getData()) < bounds.length) {
            this.func_149676_a(bounds[data][0], bounds[data][1], bounds[data][2], bounds[data][3], bounds[data][4], bounds[data][5]);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int data = 0;
            if (!entityLiving.func_70093_af()) {
                TEBase[] TE_list;
                for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, x, y, z)) {
                    if (TE_current == null || !TE_current.func_145838_q().equals((Object)this)) continue;
                    data = TE_current.getData();
                }
            }
            TE.setData(data);
        }
    }

    public boolean isSideSolid(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && this.isBlockSolid(blockAccess, x, y, z)) {
            int data = TE.getData();
            if (data == 0) {
                return true;
            }
            if (data == 3 && side == ForgeDirection.DOWN) {
                return true;
            }
            if (data == 4 && side == ForgeDirection.UP) {
                return true;
            }
            if (data == 5 && side == ForgeDirection.NORTH) {
                return true;
            }
            if (data == 6 && side == ForgeDirection.SOUTH) {
                return true;
            }
            if (data == 1 && side == ForgeDirection.WEST) {
                return true;
            }
            if (data == 2 && side == ForgeDirection.EAST) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldCheckWeakPower(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            int data = TE.getData();
            return data == 0;
        }
        return super.shouldCheckWeakPower(blockAccess, x, y, z, side);
    }

    @Override
    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        if (TE_adj.func_145838_q() == this) {
            this.func_149719_a((IBlockAccess)TE_src.func_145831_w(), TE_src.field_145851_c, TE_src.field_145848_d, TE_src.field_145849_e);
            double[] bnds_src = new double[]{this.func_149704_x(), this.func_149665_z(), this.func_149706_B(), this.func_149753_y(), this.func_149669_A(), this.func_149693_C()};
            this.func_149719_a((IBlockAccess)TE_adj.func_145831_w(), TE_adj.field_145851_c, TE_adj.field_145848_d, TE_adj.field_145849_e);
            switch (side_src) {
                case DOWN: {
                    return this.field_149756_F == 1.0 && bnds_src[1] == 0.0 && this.field_149759_B == bnds_src[0] && this.field_149755_E == bnds_src[3] && this.field_149754_D == bnds_src[2] && this.field_149757_G == bnds_src[5];
                }
                case UP: {
                    return this.field_149760_C == 0.0 && bnds_src[4] == 1.0 && this.field_149759_B == bnds_src[0] && this.field_149755_E == bnds_src[3] && this.field_149754_D == bnds_src[2] && this.field_149757_G == bnds_src[5];
                }
                case NORTH: {
                    return this.field_149757_G == 1.0 && bnds_src[2] == 0.0 && this.field_149759_B == bnds_src[0] && this.field_149755_E == bnds_src[3] && this.field_149760_C == bnds_src[1] && this.field_149756_F == bnds_src[4];
                }
                case SOUTH: {
                    return this.field_149754_D == 0.0 && bnds_src[5] == 1.0 && this.field_149759_B == bnds_src[0] && this.field_149755_E == bnds_src[3] && this.field_149760_C == bnds_src[1] && this.field_149756_F == bnds_src[4];
                }
                case WEST: {
                    return this.field_149755_E == 1.0 && bnds_src[0] == 0.0 && this.field_149760_C == bnds_src[1] && this.field_149756_F == bnds_src[4] && this.field_149754_D == bnds_src[2] && this.field_149757_G == bnds_src[5];
                }
                case EAST: {
                    return this.field_149759_B == 0.0 && bnds_src[3] == 1.0 && this.field_149760_C == bnds_src[1] && this.field_149756_F == bnds_src[4] && this.field_149754_D == bnds_src[2] && this.field_149757_G == bnds_src[5];
                }
            }
            return false;
        }
        return super.shareFaces(TE_adj, TE_src, side_adj, side_src);
    }

    @Override
    public boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersBlockRenderID;
    }
}

