/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.blocks;

import com.InfinityRaider.AgriCraft.farming.CropProduce;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirement;
import com.InfinityRaider.AgriCraft.utility.BlockWithMeta;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModPlant
extends BlockCrops
implements IGrowable {
    private GrowthRequirement growthRequirement;
    public CropProduce products = new CropProduce();
    public ArrayList<ItemStack> fruits;
    private ItemSeeds seed;
    public int tier;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private int renderType;
    private boolean isEditable;

    public BlockModPlant(Item fruit) {
        this(null, null, 0, fruit, 0, 1, 6);
    }

    public BlockModPlant(Block soil, Item fruit) {
        this(soil, null, 0, fruit, 0, 1, 6);
    }

    public BlockModPlant(Item fruit, int fruitMeta) {
        this(null, null, 0, fruit, fruitMeta, 1, 6);
    }

    public BlockModPlant(Item fruit, int fruitMeta, int tier) {
        this(null, null, 0, fruit, fruitMeta, tier, 6);
    }

    public BlockModPlant(Item fruit, int fruitMeta, int tier, int renderType) {
        this(null, null, 0, fruit, fruitMeta, tier, renderType);
    }

    public BlockModPlant(Block soil, Block base, Item fruit, int tier, int renderType) {
        this(soil, base, 0, fruit, 0, tier, renderType);
    }

    public BlockModPlant(Block soil, Item fruit, int fruitMeta) {
        this(soil, null, 0, fruit, fruitMeta, 1, 6);
    }

    public BlockModPlant(Block base, int baseMeta, Item fruit, int fruitMeta, int tier, int renderType) {
        this(Blocks.field_150458_ak, base, baseMeta, fruit, fruitMeta, tier, renderType);
    }

    public BlockModPlant(Block soil, Block base, Item fruit, int fruitMeta, int tier, int renderType) {
        this(soil, base, 0, fruit, fruitMeta, tier, renderType);
    }

    public BlockModPlant(Block soil, Block base, int baseMeta, Item fruit, int tier, int renderType) {
        this(soil, base, baseMeta, fruit, 0, tier, renderType);
    }

    public BlockModPlant(Block soil, Block base, int baseMeta, Item fruit, int fruitMeta, int tier, int renderType) {
        this(soil, base, baseMeta, fruit, fruitMeta, tier, renderType, false);
    }

    public BlockModPlant(Block soil, Block base, int baseMeta, Item fruit, int fruitMeta, int tier, int renderType, boolean isCustom) {
        GrowthRequirement.Builder builder = new GrowthRequirement.Builder();
        if (base != null) {
            builder.requiredBlock(new BlockWithMeta(base, baseMeta), GrowthRequirement.RequirementType.BELOW, true);
        }
        this.growthRequirement = soil == null || soil == Blocks.field_150458_ak ? builder.build() : builder.soil(new BlockWithMeta(soil)).build();
        this.products.addProduce(new ItemStack(fruit, 1, fruitMeta));
        this.tier = tier;
        this.func_149675_a(true);
        this.field_149783_u = true;
        this.renderType = renderType == 1 ? renderType : 6;
        this.isEditable = isCustom;
    }

    public void initializeSeed(ItemSeeds seed) {
        if (this.seed == null) {
            this.seed = seed;
        }
    }

    public ItemSeeds getSeed() {
        return this.seed;
    }

    public ArrayList<ItemStack> getFruits() {
        return this.products.getAllProducts();
    }

    public ArrayList<ItemStack> getFruit(Random rand) {
        return this.getFruit(1, rand);
    }

    public ArrayList<ItemStack> getFruit(int nr, Random rand) {
        return this.products.getProduce(nr, rand);
    }

    public boolean canEdit() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_149739_a());
        this.icons = new IIcon[4];
        for (int i = 1; i < this.icons.length + 1; ++i) {
            this.icons[i - 1] = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1) + i);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        int meta = this.getPlantMetadata((IBlockAccess)world, x, y, z);
        if (meta < 7 && this.isFertile(world, x, y, z)) {
            double rate = 1.1;
            float growthRate = SeedHelper.getBaseGrowth(this.tier);
            meta = rnd.nextDouble() > (double)growthRate * rate / 100.0 ? meta : meta + 1;
            world.func_72921_c(x, y, z, meta, 2);
        }
    }

    public boolean isMature(World world, int x, int y, int z) {
        return this.getPlantMetadata((IBlockAccess)world, x, y, z) == 7;
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.icons[0];
            }
            case 1: {
                return this.icons[0];
            }
            case 2: {
                return this.icons[1];
            }
            case 3: {
                return this.icons[1];
            }
            case 4: {
                return this.icons[1];
            }
            case 5: {
                return this.icons[2];
            }
            case 6: {
                return this.icons[2];
            }
            case 7: {
                return this.icons[3];
            }
        }
        return this.icons[(int)Math.floor(meta / 5)];
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float f, int i) {
        super.func_149690_a(world, x, y, z, meta, f, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)this.seed, 1, 0));
        if (metadata == 7) {
            list.addAll(this.getFruit(world.field_73012_v));
        }
        return list;
    }

    public Item func_149650_a(int meta, Random rand, int side) {
        return meta == 7 ? this.func_149865_P() : this.func_149866_i();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return soil instanceof BlockFarmland;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return this.growthRequirement.canGrow(world, x, y, z);
    }

    protected Item func_149866_i() {
        return this.seed;
    }

    protected Item func_149865_P() {
        Item item = null;
        ArrayList<ItemStack> items = this.getFruit(new Random());
        if (items != null && items.size() > 0 && items.get(0) != null) {
            item = items.get(0).func_77973_b();
        }
        return item;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public GrowthRequirement getGrowthRequirement() {
        return this.growthRequirement;
    }

    public void setGrowthRequirement(GrowthRequirement req) {
        this.growthRequirement = req;
    }
}

