/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.SpreadChance")
public class SpreadChance {
    @ZenMethod
    public static void override(IItemStack seed, int chance) {
        ItemStack seedToOverride = MineTweakerMC.getItemStack((IItemStack)seed);
        if (seedToOverride.func_77973_b() instanceof ItemSeeds) {
            if (chance >= 0 && chance <= 100) {
                MineTweakerAPI.apply((IUndoableAction)new OverrideAction(seedToOverride, chance));
            } else {
                MineTweakerAPI.logError((String)"Spread chance must be between 0 and 100 inclusive.");
            }
        } else {
            MineTweakerAPI.logError((String)"Spread chance can only be overwritten for items of type ItemSeeds.");
        }
    }

    private static class OverrideAction
    implements IUndoableAction {
        private final ItemStack seed;
        private final int chance;
        private int oldChance;

        public OverrideAction(ItemStack seed, int chance) {
            this.seed = seed;
            this.chance = chance;
        }

        public void apply() {
            this.oldChance = SeedHelper.overrideSpreadChance((ItemSeeds)this.seed.func_77973_b(), this.seed.func_77960_j(), this.chance);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SeedHelper.overrideSpreadChance((ItemSeeds)this.seed.func_77973_b(), this.seed.func_77960_j(), this.oldChance);
        }

        public String describe() {
            return "Overriding spread chance of " + this.seed.func_82833_r() + " to " + this.chance;
        }

        public String describeUndo() {
            return "Resetting spread chance of " + this.seed.func_82833_r() + " to " + this.oldChance;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

