/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.gardenstuff.GardenStuffHelper;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirements;
import com.InfinityRaider.AgriCraft.utility.BlockWithMeta;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import com.jaquadro.minecraft.gardencontainers.block.BlockLargePot;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GrowthRequirement {
    public static final GrowthRequirement DEFAULT = new GrowthRequirement();
    public static final int NEARBY_DEFAULT_RANGE = 4;
    private int maxBrightness = 16;
    private int minBrightness = 8;
    private BlockWithMeta soil = null;
    private BlockWithMeta requiredBlock = null;
    private boolean oreDict = false;
    private RequirementType requiredType = RequirementType.NONE;

    public boolean canGrow(World world, int x, int y, int z) {
        return this.isValidSoil(world, x, y - 1, z) && this.isBrightnessGood(world.func_72957_l(x, y, z)) && this.isBaseBlockPresent(world, x, y, z);
    }

    public boolean isBaseBlockPresent(World world, int x, int y, int z) {
        if (this.requiresBaseBlock()) {
            switch (this.requiredType) {
                case BELOW: {
                    return this.isBaseBlockBelow(world, x, y, z);
                }
                case NEARBY: {
                    return this.isBaseBlockNear(world, x, y, z);
                }
            }
        }
        return true;
    }

    private boolean isBaseBlockBelow(World world, int x, int y, int z) {
        if (this.requiresBaseBlock() && this.requiredType == RequirementType.BELOW) {
            return this.isBlockAdequate(world.func_147439_a(x, y - 2, z), world.func_72805_g(x, y - 2, z));
        }
        return true;
    }

    private boolean isBaseBlockNear(World world, int x, int y, int z) {
        if (this.requiresBaseBlock() && this.requiredType == RequirementType.NEARBY) {
            int range = 4;
            for (int xPos = x - range; xPos <= x + range; ++xPos) {
                for (int yPos = y - range; yPos <= y + range; ++yPos) {
                    for (int zPos = z - range; zPos <= z + range; ++zPos) {
                        if (!this.isBlockAdequate(world.func_147439_a(xPos, yPos, zPos), world.func_72805_g(xPos, yPos, zPos))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean isBlockAdequate(Block block, int meta) {
        if (this.oreDict) {
            return OreDictHelper.isSameOre(block, meta, this.requiredBlock.getBlock(), this.requiredBlock.getMeta());
        }
        return block == this.requiredBlock.getBlock() && meta == this.requiredBlock.getMeta();
    }

    public boolean isBrightnessGood(int lvl) {
        return lvl < this.maxBrightness && lvl >= this.minBrightness;
    }

    public boolean isValidSoil(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockWithMeta soil = new BlockWithMeta(block, meta);
        if (ModIntegration.LoadedMods.gardenStuff && block instanceof BlockLargePot) {
            soil = GardenStuffHelper.getSoil((TileEntityGarden)world.func_147438_o(x, y, z));
        }
        if (this.requiresSpecificSoil()) {
            return this.soil.equals(soil);
        }
        return GrowthRequirements.defaultSoils.contains(soil);
    }

    public boolean requiresSpecificSoil() {
        return this.soil != null;
    }

    public boolean requiresBaseBlock() {
        return this.requiredType != RequirementType.NONE;
    }

    public ItemStack requiredBlockAsItemStack() {
        return new ItemStack(this.requiredBlock.getBlock(), 1, this.requiredBlock.getMeta());
    }

    public RequirementType getRequiredType() {
        return this.requiredType;
    }

    public BlockWithMeta getSoil() {
        return this.soil;
    }

    public void setSoil(BlockWithMeta soil) {
        this.soil = soil;
        GrowthRequirements.addSoil(soil);
    }

    public int[] getBrightnessRange() {
        return new int[]{this.minBrightness, this.maxBrightness};
    }

    public void setBrightnessRange(int min, int max) {
        this.minBrightness = min;
        this.maxBrightness = max;
    }

    public void setRequiredBlock(BlockWithMeta requiredBlock, RequirementType requirementType, boolean oreDict) {
        this.requiredBlock = requiredBlock;
        this.requiredType = requirementType;
        this.oreDict = oreDict;
    }

    public BlockWithMeta getRequiredBlock() {
        return this.requiredBlock;
    }

    public boolean isOreDict() {
        return this.oreDict;
    }

    private GrowthRequirement() {
    }

    public static class Builder {
        private final GrowthRequirement growthRequirement = new GrowthRequirement();

        public Builder requiredBlock(BlockWithMeta requiredBlock, RequirementType requiredType, boolean oreDict) {
            if (requiredBlock == null || requiredType == RequirementType.NONE) {
                throw new IllegalArgumentException("Required block must be not null and required type must be other than NONE.");
            }
            this.growthRequirement.requiredBlock = requiredBlock;
            this.growthRequirement.requiredType = requiredType;
            this.growthRequirement.oreDict = oreDict;
            return this;
        }

        public Builder soil(BlockWithMeta block) {
            GrowthRequirements.addSoil(block);
            this.growthRequirement.soil = block;
            return this;
        }

        public Builder brightnessRange(int min, int max) {
            this.growthRequirement.minBrightness = min;
            this.growthRequirement.maxBrightness = max;
            return this;
        }

        public GrowthRequirement build() {
            return this.growthRequirement;
        }
    }

    public static enum RequirementType {
        NONE,
        BELOW,
        NEARBY;

    }
}

