/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import net.minecraft.item.ItemSeeds;

public class CrossOverResult {
    private final ItemSeeds seed;
    private final int meta;
    private final double chance;
    private int growth;
    private int gain;
    private int strength;

    public CrossOverResult(ItemSeeds seed, int meta, double chance) {
        this.seed = seed;
        this.meta = meta;
        this.chance = chance;
    }

    public static CrossOverResult fromTileEntityCrop(TileEntityCrop crop) {
        ItemSeeds seed = crop.seed;
        int meta = crop.seedMeta;
        double chance = SeedHelper.getSpreadChance(seed, meta);
        return new CrossOverResult(seed, meta, chance);
    }

    public static CrossOverResult fromMutation(Mutation mutation) {
        ItemSeeds seed = (ItemSeeds)mutation.result.func_77973_b();
        int meta = mutation.result.func_77960_j();
        return new CrossOverResult(seed, meta, mutation.chance);
    }

    public ItemSeeds getSeed() {
        return this.seed;
    }

    public int getMeta() {
        return this.meta;
    }

    public double getChance() {
        return this.chance;
    }

    public int getGain() {
        return this.gain;
    }

    public int getGrowth() {
        return this.growth;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStats(int growth, int gain, int strength) {
        this.growth = growth;
        this.gain = gain;
        this.strength = strength;
    }
}

