/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.farming.GrowthRequirement;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirements;
import com.InfinityRaider.AgriCraft.farming.mutation.CrossOverResult;
import com.InfinityRaider.AgriCraft.farming.mutation.ICrossOverStrategy;
import com.InfinityRaider.AgriCraft.farming.mutation.MutateStrategy;
import com.InfinityRaider.AgriCraft.farming.mutation.SpreadStrategy;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import java.util.Random;

public class MutationEngine {
    private final TileEntityCrop crop;
    private final Random random;

    public MutationEngine(TileEntityCrop crop) {
        this(crop, new Random());
    }

    public MutationEngine(TileEntityCrop crop, Random random) {
        this.crop = crop;
        this.random = random;
    }

    public void executeCrossOver() {
        ICrossOverStrategy strategy = this.rollStrategy();
        CrossOverResult result = strategy.executeStrategy();
        if (result == null || result.getSeed() == null) {
            return;
        }
        if (this.resultIsValid(result) && this.random.nextDouble() < result.getChance()) {
            this.crop.applyCrossOverResult(result);
        }
    }

    private boolean resultIsValid(CrossOverResult result) {
        GrowthRequirement growthReq = GrowthRequirements.getGrowthRequirement(result.getSeed(), result.getMeta());
        boolean valid = result.getSeed() != null && SeedHelper.isValidSeed(result.getSeed(), result.getMeta());
        return valid && growthReq.canGrow(this.crop.func_145831_w(), this.crop.field_145851_c, this.crop.field_145848_d, this.crop.field_145849_e);
    }

    public ICrossOverStrategy rollStrategy() {
        boolean spreading = this.random.nextDouble() > ConfigurationHandler.mutationChance;
        return spreading ? new SpreadStrategy(this) : new MutateStrategy(this);
    }

    public TileEntityCrop getCrop() {
        return this.crop;
    }

    public Random getRandom() {
        return this.random;
    }
}

