/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.farming.mutation.CrossOverResult;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public abstract class MutationHandler {
    private static List<Mutation> mutations;

    public static void init() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readMutationData());
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (String line : data) {
            Mutation mutation = MutationHandler.readMutation(line);
            if (mutation == null || list.contains(mutation)) continue;
            list.add(mutation);
        }
        mutations = list;
        LogHelper.info("Registered Mutations:");
        for (Mutation mutation : mutations) {
            String result = mutation.result.func_77973_b() != null ? Item.field_150901_e.func_148750_c((Object)mutation.result.func_77973_b()) + ':' + mutation.result.func_77960_j() : "null";
            String parent1 = mutation.parent1.func_77973_b() != null ? Item.field_150901_e.func_148750_c((Object)mutation.parent1.func_77973_b()) + ':' + mutation.parent1.func_77960_j() : "null";
            String parent2 = mutation.parent2.func_77973_b() != null ? Item.field_150901_e.func_148750_c((Object)mutation.parent2.func_77973_b()) + ':' + mutation.parent2.func_77960_j() : "null";
            String info = " - " + result + " = " + parent1 + " + " + parent2;
            LogHelper.info(info);
        }
    }

    private static Mutation readMutation(String input) {
        Mutation mutation = null;
        String[] data = IOHelper.getData(input);
        boolean success = data.length == 1 || data.length == 3;
        String errorMsg = "invalid number of arguments";
        if (success) {
            String mutationData = data[0];
            int indexEquals = mutationData.indexOf(61);
            int indexPlus = mutationData.indexOf(43);
            success = indexEquals > 0 && indexPlus > indexEquals;
            errorMsg = "Mutation is not defined correctly";
            if (success) {
                ItemStack resultStack = IOHelper.getStack(mutationData.substring(0, indexEquals));
                ItemStack parentStack1 = IOHelper.getStack(mutationData.substring(indexEquals + 1, indexPlus));
                ItemStack parentStack2 = IOHelper.getStack(mutationData.substring(indexPlus + 1));
                Item result = resultStack != null ? resultStack.func_77973_b() : null;
                Item parent1 = parentStack1 != null ? parentStack1.func_77973_b() : null;
                Item parent2 = parentStack2 != null ? parentStack2.func_77973_b() : null;
                success = result != null && result instanceof ItemSeeds;
                errorMsg = "resulting stack is not correct";
                if (success) {
                    success = parent1 != null && parent1 instanceof ItemSeeds;
                    errorMsg = "first parent stack is not correct";
                    if (success) {
                        success = parent2 != null && parent2 instanceof ItemSeeds;
                        errorMsg = "second parent stack is not correct";
                        if (success) {
                            mutation = new Mutation(resultStack, parentStack1, parentStack2);
                        }
                    }
                }
            }
        }
        if (!success) {
            LogHelper.info(new StringBuffer("Error when reading mutation: ").append(errorMsg).append(" (line: ").append(input).append(")"));
        }
        return mutation;
    }

    public static Mutation[] getCrossOvers(List<TileEntityCrop> crops) {
        TileEntityCrop[] parents = MutationHandler.getParents(crops);
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        switch (parents.length) {
            case 2: {
                list.addAll(MutationHandler.getMutations(parents[0], parents[1]));
                break;
            }
            case 3: {
                list.addAll(MutationHandler.getMutations(parents[0], parents[1]));
                list.addAll(MutationHandler.getMutations(parents[0], parents[2]));
                list.addAll(MutationHandler.getMutations(parents[1], parents[2]));
                break;
            }
            case 4: {
                list.addAll(MutationHandler.getMutations(parents[0], parents[1]));
                list.addAll(MutationHandler.getMutations(parents[0], parents[2]));
                list.addAll(MutationHandler.getMutations(parents[0], parents[3]));
                list.addAll(MutationHandler.getMutations(parents[1], parents[2]));
                list.addAll(MutationHandler.getMutations(parents[1], parents[3]));
                list.addAll(MutationHandler.getMutations(parents[2], parents[3]));
            }
        }
        return MutationHandler.cleanMutationArray(list.toArray(new Mutation[list.size()]));
    }

    private static TileEntityCrop[] getParents(List<TileEntityCrop> input) {
        ArrayList<TileEntityCrop> list = new ArrayList<TileEntityCrop>();
        for (TileEntityCrop crop : input) {
            if (crop == null || !crop.isMature()) continue;
            list.add(crop);
        }
        return list.toArray(new TileEntityCrop[list.size()]);
    }

    private static ArrayList<Mutation> getMutations(TileEntityCrop parent1, TileEntityCrop parent2) {
        ItemSeeds seed1 = parent1.seed;
        ItemSeeds seed2 = parent2.seed;
        int meta1 = parent1.seedMeta;
        int meta2 = parent2.seedMeta;
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (Mutation mutation : mutations) {
            if (seed1 == mutation.parent1.func_77973_b() && seed2 == mutation.parent2.func_77973_b() && meta1 == mutation.parent1.func_77960_j() && meta2 == mutation.parent2.func_77960_j()) {
                list.add(mutation);
            }
            if (seed1 != mutation.parent2.func_77973_b() || seed2 != mutation.parent1.func_77973_b() || meta1 != mutation.parent2.func_77960_j() || meta2 != mutation.parent1.func_77960_j()) continue;
            list.add(mutation);
        }
        return list;
    }

    public static void setResultStats(CrossOverResult result, List<TileEntityCrop> input, boolean mutation) {
        TileEntityCrop[] parents = MutationHandler.getParents(input);
        int size = parents.length;
        int[] growth = new int[size];
        int[] gain = new int[size];
        int[] strength = new int[size];
        for (int i = 0; i < size; ++i) {
            int multiplier = ConfigurationHandler.spreadingDifficulty;
            if (multiplier > 1) {
                multiplier = MutationHandler.canInheritStats(result.getSeed(), result.getMeta(), parents[i].seed, parents[i].seedMeta) ? 1 : (multiplier == 3 ? 0 : -1);
            }
            growth[i] = multiplier * parents[i].growth;
            gain[i] = multiplier * parents[i].gain;
            strength[i] = multiplier * parents[i].strength;
        }
        int meanGrowth = MutationHandler.getMean(growth);
        int meanGain = MutationHandler.getMean(gain);
        int meanStrength = MutationHandler.getMean(strength);
        int divisor = mutation ? ConfigurationHandler.cropStatDivisor : 1;
        result.setStats(MutationHandler.calculateStats(meanGrowth, size, divisor), MutationHandler.calculateStats(meanGain, size, divisor), MutationHandler.calculateStats(meanStrength, size, divisor));
    }

    private static int getMean(int[] input) {
        int sum = 0;
        int total = input.length;
        int mean = 0;
        if (total > 0) {
            for (int nr : input) {
                if (nr >= 0) {
                    sum += nr;
                    continue;
                }
                --total;
            }
            if (total > 0) {
                mean = Math.round((float)sum / (float)total);
            }
        }
        return mean;
    }

    private static int calculateStats(int input, int neighbours, int divisor) {
        if (neighbours == 1 && ConfigurationHandler.singleSpreadsIncrement) {
            neighbours = 2;
        }
        return Math.max(1, (input + (int)Math.round((double)Math.abs(neighbours - 1) * Math.random())) / divisor);
    }

    private static boolean canInheritStats(ItemSeeds child, int childMeta, ItemSeeds seed, int seedMeta) {
        boolean b;
        boolean bl = b = child == seed && childMeta == seedMeta;
        if (!b) {
            for (Mutation mutation : MutationHandler.getParentMutations(child, childMeta)) {
                if (mutation == null) continue;
                if (mutation.parent1.func_77973_b() == seed && mutation.parent1.func_77960_j() == seedMeta) {
                    b = true;
                    break;
                }
                if (mutation.parent2.func_77973_b() != seed || mutation.parent2.func_77960_j() != seedMeta) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    private static Mutation[] cleanMutationArray(Mutation[] input) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (Mutation mutation : input) {
            if (mutation.result == null) continue;
            list.add(mutation);
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static Mutation[] getMutations() {
        return mutations.toArray(new Mutation[mutations.size()]);
    }

    public static Mutation[] getMutations(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        if (stack.func_77973_b() instanceof ItemSeeds) {
            for (Mutation mutation : mutations) {
                if (mutation.parent2.func_77973_b() == stack.func_77973_b() && mutation.parent2.func_77960_j() == stack.func_77960_j()) {
                    list.add(new Mutation(mutation));
                }
                if (mutation.parent2.func_77973_b() == mutation.parent1.func_77973_b() && mutation.parent2.func_77960_j() == mutation.parent1.func_77960_j() || mutation.parent1.func_77973_b() != stack.func_77973_b() || mutation.parent1.func_77960_j() != stack.func_77960_j()) continue;
                list.add(new Mutation(mutation));
            }
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static Mutation[] getParentMutations(ItemSeeds seed, int meta) {
        return MutationHandler.getParentMutations(new ItemStack((Item)seed, 1, meta));
    }

    public static Mutation[] getParentMutations(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        if (stack.func_77973_b() instanceof ItemSeeds) {
            for (Mutation mutation : mutations) {
                if (mutation.result.func_77973_b() != stack.func_77973_b() || mutation.result.func_77960_j() != stack.func_77960_j()) continue;
                list.add(new Mutation(mutation));
            }
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static List<Mutation> removeMutationsByResult(ItemStack result) {
        ArrayList<Mutation> removedMutations = new ArrayList<Mutation>();
        Iterator<Mutation> iter = mutations.iterator();
        while (iter.hasNext()) {
            Mutation mutation = iter.next();
            if (!mutation.result.func_77969_a(result)) continue;
            iter.remove();
            removedMutations.add(mutation);
        }
        return removedMutations;
    }

    public static void add(Mutation mutation) {
        mutations.add(mutation);
    }

    public static void remove(Mutation mutation) {
        mutations.remove(mutation);
    }

    public static void addAll(Collection<? extends Mutation> mutationsToAdd) {
        mutations.addAll(mutationsToAdd);
    }
}

