/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.network;

import com.InfinityRaider.AgriCraft.container.ContainerSeedStorageDummy;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class MessageContainerSeedStorage
implements IMessage {
    private Item item;
    private int meta;
    private int amount;
    private EntityPlayer player;
    private int slotId;

    public MessageContainerSeedStorage() {
    }

    public MessageContainerSeedStorage(ItemStack stack, EntityPlayer player, int slotId) {
        this.item = stack.func_77973_b();
        this.meta = stack.func_77960_j();
        this.amount = stack.field_77994_a;
        this.player = player;
        this.slotId = slotId;
    }

    public void fromBytes(ByteBuf buf) {
        int itemNameLength = buf.readInt();
        String itemName = new String(buf.readBytes(itemNameLength).array());
        this.item = (Item)Item.field_150901_e.func_82594_a(itemName);
        this.meta = buf.readInt();
        this.amount = buf.readInt();
        int playerNameLength = buf.readInt();
        String playerName = new String(buf.readBytes(playerNameLength).array());
        this.player = this.getPlayer(playerName);
        this.slotId = buf.readInt();
    }

    private EntityPlayer getPlayer(String name) {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        EntityPlayer player = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && player == null) {
            EntityPlayer nextPlayer = (EntityPlayer)iterator.next();
            if (!nextPlayer.getDisplayName().equals(name)) continue;
            player = nextPlayer;
        }
        return player;
    }

    public void toBytes(ByteBuf buf) {
        String itemName = this.item == null ? "null" : Item.field_150901_e.func_148750_c((Object)this.item);
        buf.writeInt(itemName.length());
        buf.writeBytes(itemName.getBytes());
        buf.writeInt(this.meta);
        buf.writeInt(this.amount);
        String playerName = this.player.getDisplayName();
        buf.writeInt(playerName.length());
        buf.writeBytes(playerName.getBytes());
        buf.writeInt(this.slotId);
    }

    public static class MessageHandler
    implements IMessageHandler<MessageContainerSeedStorage, IMessage> {
        public IMessage onMessage(MessageContainerSeedStorage message, MessageContext context) {
            Container container = ((MessageContainerSeedStorage)message).player.field_71070_bA;
            if (container != null && container instanceof ContainerSeedStorageDummy) {
                ContainerSeedStorageDummy storage = (ContainerSeedStorageDummy)container;
                storage.moveStackFromTileEntityToPlayer(message.slotId, new ItemStack(message.item, message.amount, message.meta));
            }
            return null;
        }
    }
}

