/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.proxy;

import codechicken.nei.api.API;
import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.NEI.NEIConfig;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.handler.ItemToolTipHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.init.Items;
import com.InfinityRaider.AgriCraft.proxy.CommonProxy;
import com.InfinityRaider.AgriCraft.reference.SeedInformation;
import com.InfinityRaider.AgriCraft.renderers.RenderChannel;
import com.InfinityRaider.AgriCraft.renderers.RenderCrop;
import com.InfinityRaider.AgriCraft.renderers.RenderItemChannel;
import com.InfinityRaider.AgriCraft.renderers.RenderItemSeedAnalyzer;
import com.InfinityRaider.AgriCraft.renderers.RenderItemSprinkler;
import com.InfinityRaider.AgriCraft.renderers.RenderItemTank;
import com.InfinityRaider.AgriCraft.renderers.RenderItemValve;
import com.InfinityRaider.AgriCraft.renderers.RenderSeedAnalyzer;
import com.InfinityRaider.AgriCraft.renderers.RenderSprinkler;
import com.InfinityRaider.AgriCraft.renderers.RenderTank;
import com.InfinityRaider.AgriCraft.renderers.RenderValve;
import com.InfinityRaider.AgriCraft.tileentity.TileEntitySeedAnalyzer;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntitySprinkler;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityTank;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityValve;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.VillagerRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static int cropRenderId = -1;
    public static int tankRenderId = -1;
    public static int channelRenderId = -1;
    public static int valveRenderId = -1;

    @Override
    public int getRenderId(int nr) {
        switch (nr) {
            case 0: {
                return cropRenderId;
            }
            case 1: {
                return tankRenderId;
            }
            case 2: {
                return channelRenderId;
            }
            case 3: {
                return valveRenderId;
            }
        }
        return -1;
    }

    @Override
    public void registerRenderers() {
        cropRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderCrop renderCrops = new RenderCrop();
        RenderingRegistry.registerBlockHandler((int)cropRenderId, (ISimpleBlockRenderingHandler)renderCrops);
        RenderSeedAnalyzer renderAnalyzer = new RenderSeedAnalyzer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySeedAnalyzer.class, (TileEntitySpecialRenderer)renderAnalyzer);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Blocks.seedAnalyzer), (IItemRenderer)new RenderItemSeedAnalyzer(renderAnalyzer, new TileEntitySeedAnalyzer()));
        tankRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderTank renderTank = new RenderTank();
        RenderingRegistry.registerBlockHandler((int)tankRenderId, (ISimpleBlockRenderingHandler)renderTank);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Blocks.blockWaterTank), (IItemRenderer)new RenderItemTank(new TileEntityTank()));
        channelRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderChannel renderChannel = new RenderChannel();
        RenderingRegistry.registerBlockHandler((int)channelRenderId, (ISimpleBlockRenderingHandler)renderChannel);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Blocks.blockWaterChannel), (IItemRenderer)new RenderItemChannel(new TileEntityChannel()));
        valveRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderValve renderValve = new RenderValve();
        RenderingRegistry.registerBlockHandler((int)valveRenderId, (ISimpleBlockRenderingHandler)renderValve);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)Blocks.blockChannelValve), (IItemRenderer)new RenderItemValve(new TileEntityValve()));
        RenderSprinkler renderSprinkler = new RenderSprinkler();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySprinkler.class, (TileEntitySpecialRenderer)renderSprinkler);
        MinecraftForgeClient.registerItemRenderer((Item)Items.sprinkler, (IItemRenderer)new RenderItemSprinkler());
        if (!ConfigurationHandler.disableWorldGen && ConfigurationHandler.villagerEnabled) {
            VillagerRegistry.instance().registerVillagerSkin(78943, new ResourceLocation("textures/entity/villager/farmer.png"));
        }
        LogHelper.debug("Renderers registered");
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        FMLCommonHandler.instance().bus().register((Object)new ItemToolTipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemToolTipHandler());
    }

    @Override
    public void initNEI() {
        if (ModIntegration.LoadedMods.nei) {
            NEIConfig configNEI = new NEIConfig();
            configNEI.loadConfig();
        }
    }

    @Override
    public void hideItemInNEI(ItemStack stack) {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!modContainer.getModId().equalsIgnoreCase("NotEnoughItems")) continue;
            API.hideItem((ItemStack)stack);
        }
    }

    @Override
    public void initSeedInfo() {
        SeedInformation.init();
    }
}

