/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.utility.NBTHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySeedAnalyzer
extends TileEntityAgricraft
implements ISidedInventory {
    public ItemStack seed = null;
    public ItemStack journal = null;
    public int progress = 0;
    public ForgeDirection direction;

    public void func_145841_b(NBTTagCompound tag) {
        if (this.seed != null && this.seed.func_77973_b() != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            this.seed.func_77955_b(seedTag);
            tag.func_74782_a("seed", (NBTBase)seedTag);
        }
        if (this.journal != null && this.journal.func_77973_b() != null) {
            NBTTagCompound journalTag = new NBTTagCompound();
            this.journal.func_77955_b(journalTag);
            tag.func_74782_a("journal", (NBTBase)journalTag);
        }
        if (this.direction != null) {
            tag.func_74774_a("direction", (byte)this.direction.ordinal());
        }
        tag.func_74768_a("progress", this.progress);
        super.func_145841_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.seed = tag.func_74764_b("seed") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("seed")) : null;
        this.journal = tag.func_74764_b("journal") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("journal")) : null;
        if (tag.func_74764_b("direction")) {
            this.setDirection(tag.func_74771_c("direction"));
        }
        this.progress = tag.func_74762_e("progress");
        super.func_145839_a(tag);
    }

    public void setDirection(int direction) {
        this.direction = ForgeDirection.getOrientation((int)direction);
    }

    public boolean hasSeed() {
        return this.seed != null && this.seed.func_77973_b() instanceof ItemSeeds;
    }

    public int maxProgress() {
        return this.seed == null || !(this.seed.func_77973_b() instanceof ItemSeeds) ? 0 : SeedHelper.getSeedTier((ItemSeeds)this.seed.func_77973_b(), this.seed.func_77960_j()) * 20;
    }

    public static boolean isValid(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemSeeds) {
            if (!SeedHelper.isValidSeed((ItemSeeds)stack.func_77973_b(), stack.func_77960_j())) {
                return false;
            }
            if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("analyzed")) {
                return !stack.field_77990_d.func_74767_n("analyzed");
            }
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        boolean change = false;
        if (!this.field_145850_b.field_72995_K && this.isAnalyzing()) {
            int n = this.progress = this.progress < this.maxProgress() ? this.progress + 1 : this.maxProgress();
            if (this.progress == this.maxProgress()) {
                this.analyze();
            }
            change = true;
        }
        if (change) {
            this.markForUpdate();
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 0);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void analyze() {
        NBTTagCompound tag;
        if (this.seed.func_77942_o()) {
            tag = this.seed.func_77978_p();
            if (tag.func_74764_b("growth") && tag.func_74764_b("gain") && tag.func_74764_b("strength")) {
                tag.func_74757_a("analyzed", true);
            } else {
                SeedHelper.setNBT(tag, (short)0, (short)0, (short)0, true);
            }
        } else {
            this.seed.func_77982_d(new NBTTagCompound());
            SeedHelper.setNBT(this.seed.field_77990_d, (short)0, (short)0, (short)0, true);
        }
        if (this.hasJournal()) {
            NBTTagList list;
            if (!this.journal.func_77942_o()) {
                this.journal.func_77982_d(new NBTTagCompound());
            }
            if (!NBTHelper.listContainsStack(list = (tag = this.journal.field_77990_d).func_74764_b("discoveredSeeds") ? tag.func_150295_c("discoveredSeeds", 10) : new NBTTagList(), this.seed)) {
                NBTTagCompound seedTag = new NBTTagCompound();
                ItemStack write = this.seed.func_77946_l();
                write.field_77994_a = 1;
                write.field_77990_d = null;
                write.func_77955_b(seedTag);
                list.func_74742_a((NBTBase)seedTag);
            }
            NBTHelper.sortStacks(list);
            tag.func_74782_a("discoveredSeeds", (NBTBase)list);
        }
    }

    public boolean isAnalyzing() {
        if (this.hasSeed() && this.seed.func_77942_o() && this.seed.field_77990_d.func_74764_b("analyzed")) {
            return this.progress < this.maxProgress() && !this.seed.field_77990_d.func_74767_n("analyzed");
        }
        return this.hasSeed() && this.progress < this.maxProgress();
    }

    public boolean hasJournal() {
        return this.journal != null && this.journal.func_77973_b() != null;
    }

    public int getProgressScaled(int scale) {
        return Math.round((float)this.progress * (float)scale / (float)this.maxProgress());
    }

    public boolean func_145842_c(int id, int value) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{36, 37};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 36) {
            if (stack.func_77973_b() instanceof ItemSeeds) {
                if (!SeedHelper.isValidSeed((ItemSeeds)stack.func_77973_b(), stack.func_77960_j())) {
                    return false;
                }
                return (this.seed == null || this.canStack(stack)) && this.func_94041_b(slot, stack);
            }
        } else if (slot == 37) {
            return this.journal == null && this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot == 36 && this.seed != null && this.seed.func_77942_o()) {
            NBTTagCompound tag = this.seed.func_77978_p();
            return tag.func_74764_b("analyzed") && tag.func_74767_n("analyzed");
        }
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        switch (slot) {
            case 36: {
                return this.seed;
            }
            case 37: {
                return this.journal;
            }
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack output = null;
        if (slot == 36 && this.seed != null) {
            if (amount < this.seed.field_77994_a) {
                output = this.seed.func_77979_a(amount);
            } else {
                output = this.seed.func_77946_l();
                this.seed = null;
            }
        } else if (slot == 37 && this.journal != null) {
            output = this.journal.func_77946_l();
            this.journal = null;
        }
        this.progress = 0;
        return output;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stackInSlot;
        switch (slot) {
            case 36: {
                stackInSlot = this.seed;
                break;
            }
            case 37: {
                stackInSlot = this.journal;
                break;
            }
            default: {
                return null;
            }
        }
        if (stackInSlot != null) {
            this.func_70299_a(slot, null);
        }
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 36) {
            this.seed = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            this.progress = 0;
        } else if (slot == 37) {
            this.journal = stack;
        }
    }

    public String func_145825_b() {
        return "container.agricraft:seedAnalyzer";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 36: {
                return TileEntitySeedAnalyzer.isValid(stack);
            }
            case 37: {
                return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemJournal;
            }
        }
        return false;
    }

    public boolean canStack(ItemStack stack) {
        return this.seed.func_77973_b() == stack.func_77973_b() && this.seed.func_77960_j() == stack.func_77960_j() && this.seed.field_77990_d == stack.field_77990_d && this.seed.field_77994_a + stack.field_77994_a <= 64;
    }
}

