/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.storage;

import com.InfinityRaider.AgriCraft.network.MessageTileEntitySeedStorage;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageControllable;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageController;
import com.InfinityRaider.AgriCraft.tileentity.storage.SeedStorageSlot;
import com.InfinityRaider.AgriCraft.utility.NBTHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import com.InfinityRaider.AgriCraft.utility.interfaces.IDebuggable;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySeedStorage
extends TileEntityCustomWood
implements ISeedStorageControllable,
IDebuggable {
    public ForgeDirection direction;
    private ItemSeeds lockedSeed;
    private int lockedSeedMeta;
    private Map<Integer, SeedStorageSlot> slots = new HashMap<Integer, SeedStorageSlot>();
    private ISeedStorageController controller;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.direction != null) {
            tag.func_74774_a("direction", (byte)this.direction.ordinal());
        }
        if (this.lockedSeed != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            ItemStack seedStack = new ItemStack((Item)this.lockedSeed, 1, this.lockedSeedMeta);
            seedStack.func_77955_b(seedTag);
            tag.func_74782_a("seed", (NBTBase)seedTag);
            if (this.slots != null) {
                NBTTagList tagList = new NBTTagList();
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry == null || entry.getValue() == null) continue;
                    SeedStorageSlot slot = entry.getValue();
                    NBTTagCompound stackTag = slot.getTag();
                    NBTTagCompound slotTag = new NBTTagCompound();
                    slotTag.func_74768_a("count", slot.count);
                    slotTag.func_74777_a("growth", stackTag.func_74765_d("growth"));
                    slotTag.func_74777_a("gain", stackTag.func_74765_d("gain"));
                    slotTag.func_74777_a("strength", stackTag.func_74765_d("strength"));
                    tagList.func_74742_a((NBTBase)slotTag);
                }
                tag.func_74782_a("agricraftInv", (NBTBase)tagList);
            }
        }
        if (this.hasController()) {
            NBTHelper.addCoordsToNBT(this.controller.getCoordinates(), tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int[] coords;
        super.func_145839_a(tag);
        if (tag.func_74764_b("direction")) {
            this.setDirection(tag.func_74771_c("direction"));
        }
        this.slots = new HashMap<Integer, SeedStorageSlot>();
        if (tag.func_74764_b("seed")) {
            ItemStack seedStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("seed"));
            this.lockedSeed = (ItemSeeds)seedStack.func_77973_b();
            this.lockedSeedMeta = seedStack.func_77960_j();
            if (tag.func_74764_b("agricraftInv")) {
                NBTTagList tagList = tag.func_150295_c("agricraftInv", 10);
                int invId = this.getControllableID();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound slotTag = tagList.func_150305_b(i);
                    NBTTagCompound stackTag = new NBTTagCompound();
                    SeedHelper.setNBT(stackTag, slotTag.func_74765_d("growth"), slotTag.func_74765_d("gain"), slotTag.func_74765_d("strength"), true);
                    this.slots.put(i, new SeedStorageSlot(stackTag, slotTag.func_74762_e("count"), i, invId));
                }
            }
        }
        if ((coords = NBTHelper.getCoordsFromNBT(tag)) != null && coords.length == 3) {
            this.controller = (ISeedStorageController)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean func_145842_c(int id, int data) {
        this.func_70298_a(id, data);
        return true;
    }

    public void setDirection(int direction) {
        this.direction = ForgeDirection.getOrientation((int)direction);
    }

    public void syncSlotToClient(int slot) {
        NetworkWrapperAgriCraft.wrapper.sendToDimension((IMessage)new MessageTileEntitySeedStorage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots.get(slot)), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public boolean addStackToInventory(ItemStack stack) {
        boolean success = false;
        if (!this.field_145850_b.field_72995_K && this.hasLockedSeed() && SeedHelper.isAnalyzedSeed(stack) && this.lockedSeed == stack.func_77973_b() && this.lockedSeedMeta == stack.func_77960_j()) {
            int lastId = 0;
            for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                int n = lastId = entry.getKey() > lastId ? entry.getKey() : lastId;
                if (entry.getValue() == null || !ItemStack.func_77970_a((ItemStack)entry.getValue().getStack((Item)this.lockedSeed, this.lockedSeedMeta), (ItemStack)stack)) continue;
                this.func_70299_a(entry.getKey(), stack);
                success = true;
                break;
            }
            if (!success) {
                this.func_70299_a(lastId + 1, stack);
                success = true;
            }
        }
        return success;
    }

    public ArrayList<ItemStack> getInventory() {
        ArrayList<ItemStack> stacks = null;
        if (this.hasLockedSeed()) {
            stacks = new ArrayList<ItemStack>();
            for (Map.Entry<Integer, SeedStorageSlot> entries : this.slots.entrySet()) {
                if (entries == null || entries.getValue() == null) continue;
                stacks.add(entries.getValue().getStack((Item)this.lockedSeed, this.lockedSeedMeta));
            }
        }
        return stacks;
    }

    @Override
    public List<SeedStorageSlot> getSlots(ItemSeeds seed, int meta) {
        ArrayList<SeedStorageSlot> list = new ArrayList<SeedStorageSlot>();
        if (this.lockedSeed != null && this.lockedSeed == seed && this.lockedSeedMeta == meta) {
            list = new ArrayList<SeedStorageSlot>(this.slots.values());
        }
        return list;
    }

    @Override
    public int[] getControllerCoords() {
        return this.controller != null ? this.controller.getCoordinates() : null;
    }

    @Override
    public int[] getCoords() {
        return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public ISeedStorageController getController() {
        return this.controller;
    }

    @Override
    public boolean hasController() {
        return this.controller != null;
    }

    @Override
    public boolean hasLockedSeed() {
        return this.lockedSeed != null;
    }

    @Override
    public void setLockedSeed(ItemSeeds seed, int meta) {
        if (!this.hasLockedSeed()) {
            this.lockedSeed = seed;
            this.lockedSeedMeta = meta;
            this.markForUpdate();
        }
    }

    @Override
    public ItemStack getLockedSeed() {
        return new ItemStack((Item)this.lockedSeed, 1, this.lockedSeedMeta);
    }

    @Override
    public int getControllableID() {
        int id = -1;
        if (this.hasController()) {
            id = this.getController().getControllableID(this);
        }
        return id;
    }

    public int func_70302_i_() {
        return 1000;
    }

    public ItemStack func_70301_a(int slot) {
        SeedStorageSlot slotAt;
        ItemStack stackInSlot = null;
        if (this.slots != null && (slotAt = this.slots.get(slot %= 1000)) != null) {
            stackInSlot = slotAt.getStack((Item)this.lockedSeed, this.lockedSeedMeta);
        }
        return stackInSlot;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        SeedStorageSlot slotAt;
        ItemStack stackInSlot = null;
        if (this.slots != null && (slotAt = this.slots.get(slot %= 1000)) != null) {
            stackInSlot = slotAt.getStack((Item)this.lockedSeed, this.lockedSeedMeta);
            if (slotAt.count <= amount) {
                this.slots.remove(slot);
            } else {
                slotAt.count -= amount;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), slot, amount);
        }
        return stackInSlot;
    }

    public ItemStack func_70304_b(int slot) {
        slot %= 1000;
        ItemStack stackInSlot = null;
        if (this.slots != null) {
            stackInSlot = this.func_70301_a(slot).func_77946_l();
        }
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack inputStack) {
        if (this.func_94041_b(slot %= 1000, inputStack)) {
            SeedStorageSlot slotAt = this.slots.get(slot);
            if (slotAt != null) {
                slotAt.count += inputStack.field_77994_a;
            } else {
                this.slots.put(slot, new SeedStorageSlot(inputStack.func_77978_p(), inputStack.field_77994_a, slot, this.getControllableID()));
            }
            if (!this.field_145850_b.field_72995_K) {
                this.syncSlotToClient(slot);
            }
        }
    }

    public String func_145825_b() {
        return "AgriCraft".toLowerCase() + ":" + "seedStorage";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.hasLockedSeed() && stack.func_77973_b() == this.lockedSeed && stack.func_77960_j() == this.lockedSeedMeta && SeedHelper.isAnalyzedSeed(stack)) {
            SeedStorageSlot slotAt = this.slots.get(slot);
            return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.func_70301_a(slot));
        }
        return false;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        String info = this.lockedSeed == null ? "null" : this.getLockedSeed().func_82833_r();
        int size = this.slots == null ? 0 : this.slots.size();
        list.add("Locked Seed: " + info);
        list.add("Number of seeds: " + size);
    }
}

