/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import ttftcuts.atg.ATG;
import ttftcuts.atg.config.configfiles.ATGBiomeConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.gen.ATGGenLayerHeight;
import ttftcuts.atg.gen.ATGGenLayerMoisture;
import ttftcuts.atg.gen.ATGGenLayerTemperature;

public class ATGChunkManager
extends WorldChunkManager {
    protected ATGBiomeManager biomeManager = ATG.biomeManager;
    private ATGGenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private ATGGenLayerHeight rawGen;
    private ATGGenLayerTemperature rawTemp;
    private ATGGenLayerMoisture rawMoisture;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> biomesToSpawnIn = new ArrayList<BiomeGenBase>();
    protected BiomeGenBase[][] biomeLists;

    protected ATGChunkManager() {
        this.biomesToSpawnIn.addAll(allowedBiomes);
    }

    public ATGChunkManager(long seed, WorldType worldType) {
        this();
        GenLayer[] gens = ATGGenLayer.initializeAllBiomeGenerators(seed, worldType);
        this.genBiomes = (ATGGenLayer)gens[0];
        this.biomeIndexLayer = gens[1];
        this.rawGen = (ATGGenLayerHeight)gens[2];
        this.rawTemp = (ATGGenLayerTemperature)gens[3];
        this.rawMoisture = (ATGGenLayerMoisture)gens[4];
    }

    public ATGChunkManager(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public int[] getRawGenInts(int x, int z, int w, int h) {
        return this.rawGen.func_75904_a(x, z, w, h);
    }

    public int getRawHeight(int x, int z) {
        return this.rawGen.getInt(x, z);
    }

    public double getRawHeightDouble(int x, int z) {
        return this.rawGen.getDouble(x, z);
    }

    public double getRawTempDouble(int x, int z) {
        return this.rawTemp.getDouble(x, z);
    }

    public double getRawMoistureDouble(int x, int z) {
        return this.rawMoisture.getDouble(x, z);
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        BiomeGenBase out = this.biomeCache.func_76837_b(par1, par2);
        if (out == null) {
            System.out.println("################# MISSING BIOME GEN INFO AT " + par1 + "," + par2);
            return BiomeGenBase.field_76772_c;
        }
        return out;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var6 = this.genBiomes.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            par1ArrayOfBiomeGenBase[var7] = BiomeGenBase.func_150568_d((int)var6[var7]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
            BiomeGenBase[] var9 = this.biomeCache.func_76839_e(par2, par3);
            System.arraycopy(var9, 0, par1ArrayOfBiomeGenBase, 0, par4 * par5);
            return par1ArrayOfBiomeGenBase;
        }
        int[] var7 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public ChunkPosition func_150795_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        IntCache.func_76446_a();
        int var6 = par1 - par3 >> 2;
        int var7 = par2 - par3 >> 2;
        int var8 = par1 + par3 >> 2;
        int var9 = par2 + par3 >> 2;
        int var10 = var8 - var6 + 1;
        int var11 = var9 - var7 + 1;
        int[] var12 = this.genBiomes.func_75904_a(var6, var7, var10, var11);
        ChunkPosition var13 = null;
        int var14 = 0;
        for (int var15 = 0; var15 < var10 * var11; ++var15) {
            int var16 = var6 + var15 % var10 << 2;
            int var17 = var7 + var15 / var10 << 2;
            BiomeGenBase var18 = BiomeGenBase.func_150568_d((int)var12[var15]);
            if (!par4List.contains(var18) || var13 != null && par5Random.nextInt(var14 + 1) != 0) continue;
            var13 = new ChunkPosition(var16, 0, var17);
            ++var14;
        }
        return var13;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8;
            par1ArrayOfFloat[var7] = var8 = 1.0f;
        }
        return par1ArrayOfFloat;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public boolean func_76940_a(int x, int z, int radius, List allowed) {
        IntCache.func_76446_a();
        int xmin = x - (radius >> 2);
        int zmin = z - (radius >> 2);
        int xmax = x + (radius >> 2);
        int zmax = z + (radius >> 2);
        int xsize = xmax - xmin + 1;
        int zsize = zmax - zmin + 1;
        BiomeGenBase[] biomes = this.func_76931_a(null, xmin, zmin, xsize, zsize, false);
        try {
            for (int i = 0; i < xsize * zsize; ++i) {
                BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomes[i].field_76756_M);
                if (!allowed.contains(biome)) {
                    return false;
                }
                if (ATGBiomeConfig.villages[biomes[i].field_76756_M].getBoolean()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)((Object)((Object)this.genBiomes)).toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", (Object)allowed);
            throw new ReportedException(crashreport);
        }
    }
}

