/*
 * Decompiled with CFR 0.152.
 */
package com.mark719.magicalcrops.seedbags;

import com.mark719.magicalcrops.seedbags.Planter;
import com.mark719.magicalcrops.seedbags.PlantingLogic;
import com.mark719.magicalcrops.seedbags.Point;
import com.mark719.magicalcrops.seedbags.SeedInventory;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VeinPlanterInstance {
    private ConcurrentLinkedQueue<Point> plantQueue = new ConcurrentLinkedQueue();
    private World world;
    private ForgeDirection direction;
    private boolean finished;
    private Planter usedPlanter;
    private SeedInventory inventory;
    private EntityPlayer player;
    private Point initialBlock;

    public VeinPlanterInstance(EntityPlayer player, IInventory inventory, Planter usedPlanter, World world, int x, int y, int z, ForgeDirection direction) {
        this.world = world;
        this.direction = direction;
        this.finished = false;
        this.usedPlanter = usedPlanter;
        if (inventory instanceof SeedInventory) {
            this.inventory = (SeedInventory)inventory;
        }
        this.player = player;
        this.initialBlock = new Point(x, y, z);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void ticker(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.plantScheduled();
        }
    }

    public synchronized void plantField(int x, int y, int z) {
        if (this.world == null || this.usedPlanter == null || this.inventory == null || !(this.usedPlanter instanceof Planter)) {
            this.finished = true;
        }
        if (this.finished) {
            return;
        }
        int d = 1;
        for (int dx = -d; dx <= d; ++dx) {
            for (int dy = -d; dy <= d; ++dy) {
                for (int dz = -d; dz <= d; ++dz) {
                    int range;
                    Point blockPos;
                    if (dx == 0 && dz == 0 || !this.initialBlock.isWithinRange(blockPos = new Point(x + dx, y + dy, z + dz), range = 75) && range > 0) continue;
                    if (this.player.func_71024_bL().func_75116_a() < 2) {
                        this.player.func_146105_b((IChatComponent)new ChatComponentTranslation("PlanterHelper:TooHungry", new Object[0]));
                        this.finished = true;
                        return;
                    }
                    if (!this.usedPlanter.canPlant(this.inventory, this.world, blockPos.getX(), blockPos.getY(), blockPos.getZ(), this.direction)) continue;
                    boolean success = this.usedPlanter.plantSeedInPlace(this.inventory, this.world, blockPos.getX(), blockPos.getY(), blockPos.getZ(), this.direction);
                    if (success) {
                        this.player.func_71020_j(0.02f);
                        this.plantQueue.add(blockPos);
                    }
                    if (PlantingLogic.getSeedsSlot(this.inventory, this.usedPlanter.getFirstSlot(this.inventory)) >= 0) continue;
                    this.finished = true;
                }
            }
        }
    }

    public void plantScheduled() {
        int speed = 20;
        for (int i = 0; i < speed; ++i) {
            if (!this.plantQueue.isEmpty() && !this.finished) {
                if (this.player.func_71024_bL().func_75116_a() < 2) {
                    this.player.func_146105_b((IChatComponent)new ChatComponentTranslation("PlanterHelper:TooHungry", new Object[0]));
                    this.finished = true;
                    return;
                }
            } else {
                return;
            }
            Point target = (Point)this.plantQueue.remove();
            this.plantField(target.getX(), target.getY(), target.getZ());
        }
    }
}

