/*
 * Decompiled with CFR 0.152.
 */
package vdvman1.betterAnvil;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import vdvman1.betterAnvil.Config;
import vdvman1.betterAnvil.Utils;
import vdvman1.betterAnvil.block.BlockAnvilBA;
import vdvman1.betterAnvil.gui.GuiHandler;
import vdvman1.betterAnvil.proxy.CommonProxy;

@Mod(modid="BetterAnvil", name="Better Anvils", version="4.0.0.0")
public class BetterAnvil {
    public static final String modid = "BetterAnvil";
    public static final String channel = "BetterAnvil";
    public static final String modName = "Better Anvils";
    public static final String version = "4.0.0.0";
    public static Block anvil;
    public static Configuration config;
    public static final String catAdjustments = "Adjustments";
    @Mod.Instance(value="BetterAnvil")
    public static BetterAnvil instance;
    @SidedProxy(clientSide="vdvman1.betterAnvil.proxy.ClientProxy", serverSide="vdvman1.betterAnvil.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Config.isLegacyMode = config.get("general", "legacyMode", false).getBoolean(false);
        Config.breakChance = config.get(catAdjustments, "breakChance", 12).getDouble(12.0) / 100.0;
        Config.costMultiplier = config.get(catAdjustments, "anvilCostMultiplier", 1).getDouble(1.0);
        Config.renamingCost = config.get(catAdjustments, "renamingCost", 5).getInt(5);
        Config.renamingRepairBonus = config.get(catAdjustments, "renamingRepairBonus", 1).getInt(1);
        Config.mainRepairBonusPercent = config.get(catAdjustments, "mainRepairBonusPercent", 12).getInt(12) / 100;
        Config.repairCostPerItem = config.get(catAdjustments, "repairCostPerItem", 3).getInt(3);
        Property prop = config.get(catAdjustments, "enchantCombineRepairCost", 2);
        prop.comment = "Cost to increase an enchantment by a level";
        Config.enchantCombineRepairCost = prop.getInt(2);
        prop = config.get(catAdjustments, "enchantTransferRepairCost", 1);
        prop.comment = "Cost to transfer an enchantment to a tool";
        Config.enchantTransferRepairCost = prop.getInt(1);
        prop = config.get(catAdjustments, "enchantCombineRepairBonus", 2);
        prop.comment = "Repair bonus added when increasing an enchantment by a level";
        Config.enchantCombineRepairBonus = prop.getInt(2);
        prop = config.get(catAdjustments, "enchantTransferRepairBonus", 1);
        prop.comment = "Repair bonus added when transfering an enchantment to a tool";
        Config.enchantTransferRepairBonus = prop.getInt(1);
        prop = config.get(catAdjustments, "copyEnchantToBookCostMultiplier", 1);
        prop.comment = "Cost muliplier per enchantment copied onto a book\nThis is multiplied by the enchantment level";
        Config.copyEnchantToBookCostMultiplier = prop.getInt(2);
        prop = config.get(catAdjustments, "copyEnchantToBookRepairBonus", 1);
        prop.comment = "Repair bonus added when copying an enchantment to a book";
        Config.copyEnchantToBookRepairBonus = prop.getInt(1);
        prop = config.get(catAdjustments, "itemRepairAmount", 25);
        prop.comment = "Percentage each item will repair the tool by";
        Config.itemRepairAmount = (double)prop.getInt(25) / 100.0;
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Object mcAnvil = null;
        try {
            anvil = new BlockAnvilBA().func_149711_c(5.0f).func_149672_a(Block.field_149788_p).func_149752_b(2000.0f).func_149663_c("anvil");
            GameRegistry.registerBlock((Block)anvil, (String)"anvilba");
        }
        catch (SecurityException e) {
            System.out.println("Could not replace BlockAnvil, SecurityException.\nYou are using too high security levels, please lower them.\nDisabling Better Anvils");
            return;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Could not replace BlockAnvil, IllegalArgumentException.\nThis should never happen!\nThis means that BlockAnvil could not be set to BlockAnvilBA.\nPlease let vdvman1 know ASAP!");
            e.printStackTrace();
            System.out.println("Disabling Better Anvils");
            return;
        }
        try {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(anvil, 1), (Object[])new Object[]{"III", " I ", "iii", Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('i'), Items.field_151042_j});
        }
        catch (SecurityException e) {
            System.out.println("Could not replace anvil recipe, SecurityException.\nYou are using too high security levels, please lower them.\nBetter Anvils may/may not work at this stage");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Could not replace anvil recipe, IllegalArgumentException.\nThis should never happen!\nThis means that the anvil recipe could not be set/retrieved.\nPlease let vdvman1 know ASAP!");
            e.printStackTrace();
            System.out.println("Better Anvils may/may not work at this stage");
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null) continue;
            String enchName = Utils.getEnchName(ench);
            int defaulLimit = ench.func_77325_b();
            int enchLimit = config.get("Enchantment Limits", enchName, defaulLimit).getInt(5);
            Config.enchantLimits.put(ench.field_77352_x, enchLimit);
            ArrayList<String> defaultBlackList = new ArrayList<String>();
            for (Enchantment ench1 : Enchantment.field_77331_b) {
                if (ench1 == null || ench1.field_77352_x == ench.field_77352_x || ench.func_77326_a(ench1)) continue;
                String ench1Name = Utils.getEnchName(ench1);
                defaultBlackList.add(ench1Name);
            }
            String[] enchBlackList = config.get("Enchantment Blacklist", enchName, defaultBlackList.toArray(new String[0])).getStringList();
            Config.enchantBlackList.put(ench.field_77352_x, enchBlackList);
        }
        config.save();
    }
}

