/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex;

import cpw.mods.fml.common.event.FMLInterModComms;
import ivorius.ivtoolkit.tools.IvFMLIntercommHandler;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.worldgen.StructureSelector;
import ivorius.reccomplex.worldgen.inventory.GenericItemCollectionRegistry;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.helpers.Strings;

public class RCCommunicationHandler
extends IvFMLIntercommHandler {
    public RCCommunicationHandler(Logger logger, String modOwnerID, Object modInstance) {
        super(logger, modOwnerID, modInstance);
    }

    protected boolean handleMessage(FMLInterModComms.IMCMessage message, boolean server, boolean runtime) {
        if (this.isMessage("loadStructure", message, NBTTagCompound.class)) {
            boolean generates;
            String structureID;
            NBTTagCompound cmp = message.getNBTValue();
            String structurePath = cmp.func_74779_i("structurePath");
            if (!StructureRegistry.registerStructure(new ResourceLocation(structurePath), structureID = cmp.func_74779_i("structureID"), generates = cmp.func_74767_n("generates"))) {
                this.getLogger().warn(String.format("Could not find structure with path '%s and id '%s'", structurePath, structureID));
            }
            return true;
        }
        if (this.isMessage("loadInventoryGenerator", message, NBTTagCompound.class)) {
            boolean generates;
            String genID;
            NBTTagCompound cmp = message.getNBTValue();
            String genPath = cmp.func_74779_i("genPath");
            if (!GenericItemCollectionRegistry.register(new ResourceLocation(genPath), genID = cmp.func_74779_i("genID"), generates = cmp.func_74767_n("generates"))) {
                this.getLogger().warn(String.format("Could not find inventory generator with path '%s and id '%s'", genPath, genID));
            }
            return true;
        }
        if (this.isMessage("registerDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.registerDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'types' key!");
            }
            return true;
        }
        if (this.isMessage("unregisterDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, null);
            }
            return true;
        }
        if (this.isMessage("registerDimensionType", message, String.class)) {
            DimensionDictionary.registerType(message.getStringValue());
            return true;
        }
        if (this.isMessage("registerDimensionSubtypes", message, String.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"subtypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)type)) {
                DimensionDictionary.registerSubtypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'subtypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerDimensionSupertypes", message, String.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"supertypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)type)) {
                DimensionDictionary.registerSupertypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'supertypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerSimpleSpawnCategory", message, String.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String id = cmp.func_74779_i("id");
            float defaultSpawnChance = cmp.func_74760_g("defaultSpawnChance");
            boolean selectableInGui = cmp.func_74767_n("selectableInGui");
            int structureMinCap = cmp.func_74762_e("structureMinCap");
            String[] biomeTypes = IvNBTHelper.readNBTStrings((String)"biomeTypes", (NBTTagCompound)cmp);
            if (!Strings.isEmpty((CharSequence)id)) {
                StructureSelector.GenerationInfo[] biomeInfos = new StructureSelector.GenerationInfo[biomeTypes.length];
                for (int i = 0; i < biomeTypes.length; ++i) {
                    String[] parts = biomeTypes[i].split(":", 2);
                    biomeInfos[i] = new StructureSelector.GenerationInfo(Float.valueOf(parts[0]).floatValue(), new BiomeMatcher(parts[1]));
                }
                StructureSelector.registerCategory(id, new StructureSelector.SimpleCategory(defaultSpawnChance, Arrays.asList(biomeInfos), selectableInGui, structureMinCap));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'id' key!");
            }
            return true;
        }
        return false;
    }
}

