/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.BlockMazeGenerator;
import ivorius.reccomplex.blocks.BlockNaturalFloor;
import ivorius.reccomplex.blocks.BlockNegativeSpace;
import ivorius.reccomplex.blocks.BlockSpawnCommand;
import ivorius.reccomplex.blocks.BlockStructureGenerator;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.blocks.TileEntityMazeGenerator;
import ivorius.reccomplex.blocks.TileEntitySpawnCommand;
import ivorius.reccomplex.blocks.TileEntityStructureGenerator;
import ivorius.reccomplex.blocks.materials.MaterialNegativeSpace;
import ivorius.reccomplex.blocks.materials.RCMaterials;
import ivorius.reccomplex.client.rendering.RCBlockRendering;
import ivorius.reccomplex.gui.RCCreativeTabs;
import ivorius.reccomplex.items.ItemArtifactGenerator;
import ivorius.reccomplex.items.ItemBlockGenericSolid;
import ivorius.reccomplex.items.ItemBlockNegativeSpace;
import ivorius.reccomplex.items.ItemBlockSelectorBlock;
import ivorius.reccomplex.items.ItemBlockSelectorFloating;
import ivorius.reccomplex.items.ItemBookGenerator;
import ivorius.reccomplex.items.ItemInventoryGenComponentTag;
import ivorius.reccomplex.items.ItemInventoryGenMultiTag;
import ivorius.reccomplex.items.ItemInventoryGenSingleTag;
import ivorius.reccomplex.items.ItemMazeGenerator;
import ivorius.reccomplex.items.ItemStructureGenerator;
import ivorius.reccomplex.items.RCItems;
import ivorius.reccomplex.json.SerializableStringTypeRegistry;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.random.Poem;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.structures.OperationGenerateStructure;
import ivorius.reccomplex.structures.OperationMoveStructure;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.BiomeGenerationInfo;
import ivorius.reccomplex.structures.generic.DimensionGenerationInfo;
import ivorius.reccomplex.structures.generic.WeightedBlockState;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StaticGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.StructureListGenerationInfo;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import ivorius.reccomplex.structures.generic.presets.BiomeMatcherPresets;
import ivorius.reccomplex.structures.generic.presets.DimensionMatcherPresets;
import ivorius.reccomplex.structures.generic.presets.WeightedBlockStatePresets;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerNatural;
import ivorius.reccomplex.structures.generic.transformers.TransformerNaturalAir;
import ivorius.reccomplex.structures.generic.transformers.TransformerNegativeSpace;
import ivorius.reccomplex.structures.generic.transformers.TransformerPillar;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplaceAll;
import ivorius.reccomplex.structures.generic.transformers.TransformerRuins;
import ivorius.reccomplex.structures.schematics.OperationGenerateSchematic;
import ivorius.reccomplex.utils.FMLUtils;
import ivorius.reccomplex.worldgen.StructureSelector;
import ivorius.reccomplex.worldgen.inventory.RCInventoryGenerators;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.BiomeDictionary;

public class RCRegistryHandler {
    public static void preInit(FMLPreInitializationEvent event, RecurrentComplex mod) {
        if (!RecurrentComplex.isLite()) {
            RCCreativeTabs.tabStructureTools = new CreativeTabs("structureTools"){

                public Item func_78016_d() {
                    return RCItems.blockSelector;
                }
            };
            RCCreativeTabs.tabInventoryGenerators = new CreativeTabs("inventoryGenerators"){

                public Item func_78016_d() {
                    return RCItems.inventoryGenerationTag;
                }
            };
        }
        RCMaterials.materialNegativeSpace = new MaterialNegativeSpace();
        RCMaterials.materialGenericSolid = new Material(MapColor.field_151665_m);
        RCItems.blockSelector = new ItemBlockSelectorBlock().func_77655_b("blockSelector").func_111206_d(RecurrentComplex.textureBase + "blockSelector");
        RCItems.blockSelector.func_77637_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCItems.blockSelector, "blockSelector");
        RCItems.blockSelectorFloating = new ItemBlockSelectorFloating().func_77655_b("blockSelectorFloating").func_111206_d(RecurrentComplex.textureBase + "blockSelectorFloating");
        RCItems.blockSelectorFloating.func_77637_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCItems.blockSelectorFloating, "blockSelectorFloating");
        RCItems.inventoryGenerationTag = (ItemInventoryGenMultiTag)new ItemInventoryGenMultiTag().func_77655_b("inventoryGenerationTag").func_111206_d(RecurrentComplex.textureBase + "inventoryGenerationTag");
        RCItems.inventoryGenerationTag.func_77637_a(RCCreativeTabs.tabInventoryGenerators);
        RCRegistryHandler.register(RCItems.inventoryGenerationTag, "inventoryGenerationTag");
        RCItems.inventoryGenerationSingleTag = (ItemInventoryGenSingleTag)new ItemInventoryGenSingleTag().func_77655_b("inventoryGenerationSingleTag").func_111206_d(RecurrentComplex.textureBase + "inventoryGenerationSingleTag");
        RCItems.inventoryGenerationSingleTag.func_77637_a(RCCreativeTabs.tabInventoryGenerators);
        RCRegistryHandler.register(RCItems.inventoryGenerationSingleTag, "inventoryGenerationSingleTag");
        RCItems.inventoryGenerationComponentTag = (ItemInventoryGenComponentTag)new ItemInventoryGenComponentTag().func_77655_b("inventoryGenerationComponentTag").func_111206_d(RecurrentComplex.textureBase + "inventoryGenerationComponentTag");
        RCItems.inventoryGenerationComponentTag.func_77637_a(RCCreativeTabs.tabInventoryGenerators);
        RCRegistryHandler.register(RCItems.inventoryGenerationComponentTag, "inventory_generation_component_tag");
        RCItems.artifactGenerationTag = new ItemArtifactGenerator().func_77655_b("artifactGenerationTag").func_111206_d(RecurrentComplex.textureBase + "artifactGenerationTag");
        RCItems.artifactGenerationTag.func_77637_a(RCCreativeTabs.tabInventoryGenerators);
        RCRegistryHandler.register(RCItems.artifactGenerationTag, "artifactGenerationTag");
        RCItems.bookGenerationTag = new ItemBookGenerator().func_77655_b("bookGenerationTag").func_111206_d(RecurrentComplex.textureBase + "bookGenerationTag");
        RCItems.bookGenerationTag.func_77637_a(RCCreativeTabs.tabInventoryGenerators);
        RCRegistryHandler.register(RCItems.bookGenerationTag, "bookGenerationTag");
        RCBlocks.negativeSpace = new BlockNegativeSpace().func_149663_c("negativeSpace").func_149658_d(RecurrentComplex.textureBase + "negativeSpace");
        RCBlocks.negativeSpace.func_149647_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCBlocks.negativeSpace, ItemBlockNegativeSpace.class, "negativeSpace", new Object[0]);
        RCBlocks.naturalFloor = new BlockNaturalFloor().func_149663_c("naturalFloor").func_149658_d(RecurrentComplex.textureBase + "naturalFloor");
        RCBlocks.naturalFloor.func_149647_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCBlocks.naturalFloor, ItemBlockGenericSolid.class, "naturalFloor", new Object[0]);
        RCBlocks.structureGenerator = new BlockStructureGenerator().func_149663_c("structureGenerator").func_149658_d(RecurrentComplex.textureBase + "structureGenerator");
        RCBlocks.structureGenerator.func_149647_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCBlocks.structureGenerator, ItemStructureGenerator.class, "structureGenerator", new Object[0]);
        RCRegistryHandler.register(TileEntityStructureGenerator.class, "RCStructureGenerator", "SGStructureGenerator");
        RCBlocks.mazeGenerator = new BlockMazeGenerator().func_149663_c("mazeGenerator").func_149658_d(RecurrentComplex.textureBase + "mazeGenerator");
        RCBlocks.mazeGenerator.func_149647_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCBlocks.mazeGenerator, ItemMazeGenerator.class, "mazeGenerator", new Object[0]);
        RCRegistryHandler.register(TileEntityMazeGenerator.class, "RCMazeGenerator", "SGMazeGenerator");
        RCBlocks.spawnCommands = new BlockSpawnCommand().func_149663_c("spawnCommand").func_149658_d(RecurrentComplex.textureBase + "spawnCommand");
        RCBlocks.spawnCommands.func_149647_a(RCCreativeTabs.tabStructureTools);
        RCRegistryHandler.register(RCBlocks.spawnCommands, ItemMazeGenerator.class, "weighted_command_block", new Object[0]);
        RCRegistryHandler.register(TileEntitySpawnCommand.class, "RCSpawnCommand", new String[0]);
        RCRegistryHandler.registerDimensionPresets();
        RCRegistryHandler.registerBiomePresets();
        RCRegistryHandler.registerBlockStatePresets();
    }

    public static void register(Item item, String id) {
        if (!RecurrentComplex.isLite()) {
            GameRegistry.registerItem((Item)item, (String)id);
        } else {
            MCRegistrySpecial.INSTANCE.register(FMLUtils.addPrefix(id), item);
        }
    }

    public static void register(Block block, String id) {
        if (!RecurrentComplex.isLite()) {
            GameRegistry.registerBlock((Block)block, (String)id);
        } else {
            MCRegistrySpecial.INSTANCE.register(FMLUtils.addPrefix(id), block);
            MCRegistrySpecial.INSTANCE.register(FMLUtils.addPrefix(id), (Item)new ItemBlock(block));
        }
    }

    public static void register(Block block, Class<? extends ItemBlock> itemClass, String id, Object ... itemArgs) {
        if (!RecurrentComplex.isLite()) {
            GameRegistry.registerBlock((Block)block, itemClass, (String)id, (Object[])itemArgs);
        } else {
            MCRegistrySpecial.INSTANCE.register(FMLUtils.addPrefix(id), block);
            ItemBlock item = FMLUtils.constructItem(block, itemClass, itemArgs);
            if (item != null) {
                MCRegistrySpecial.INSTANCE.register(FMLUtils.addPrefix(id), (Item)item);
            }
        }
    }

    public static void register(Class<? extends TileEntity> tileEntity, String id, String ... alternatives) {
        if (!RecurrentComplex.isLite()) {
            GameRegistry.registerTileEntityWithAlternatives(tileEntity, (String)id, (String[])alternatives);
        } else {
            MCRegistrySpecial.INSTANCE.register(id, tileEntity);
            for (String aid : alternatives) {
                MCRegistrySpecial.INSTANCE.register(aid, tileEntity);
            }
        }
    }

    public static void load(FMLInitializationEvent event, RecurrentComplex mod) {
        MCRegistrySpecial mcRegistry = MCRegistrySpecial.INSTANCE;
        SerializableStringTypeRegistry<Transformer> transformerRegistry = StructureRegistry.getTransformerRegistry();
        transformerRegistry.registerType("natural", TransformerNatural.class, new TransformerNatural.Serializer(mcRegistry));
        transformerRegistry.registerType("naturalAir", TransformerNaturalAir.class, new TransformerNaturalAir.Serializer(mcRegistry));
        transformerRegistry.registerType("pillar", TransformerPillar.class, new TransformerPillar.Serializer(mcRegistry));
        transformerRegistry.registerType("replaceAll", TransformerReplaceAll.class, new TransformerReplaceAll.Serializer(mcRegistry));
        transformerRegistry.registerType("replace", TransformerReplace.class, new TransformerReplace.Serializer(mcRegistry));
        transformerRegistry.registerType("ruins", TransformerRuins.class, new TransformerRuins.Serializer(mcRegistry));
        transformerRegistry.registerType("negativeSpace", TransformerNegativeSpace.class, new TransformerNegativeSpace.Serializer(mcRegistry));
        SerializableStringTypeRegistry<StructureGenerationInfo> genInfoRegistry = StructureRegistry.getStructureGenerationInfoRegistry();
        genInfoRegistry.registerType("natural", NaturalGenerationInfo.class, new NaturalGenerationInfo.Serializer());
        genInfoRegistry.registerType("structureList", StructureListGenerationInfo.class, new StructureListGenerationInfo.Serializer());
        genInfoRegistry.registerType("mazeComponent", MazeGenerationInfo.class, new MazeGenerationInfo.Serializer());
        genInfoRegistry.registerType("static", StaticGenerationInfo.class, new StaticGenerationInfo.Serializer());
        genInfoRegistry.registerType("vanilla", VanillaStructureGenerationInfo.class, new VanillaStructureGenerationInfo.Serializer());
        StructureSelector.registerCategory("frequent", new StructureSelector.SimpleCategory(0.06666667f, Collections.emptyList(), true));
        StructureSelector.registerCategory("decoration", new StructureSelector.SimpleCategory(0.0125f, Collections.emptyList(), true));
        StructureSelector.registerCategory("rare", new StructureSelector.SimpleCategory(4.0E-4f, Collections.emptyList(), true));
        StructureSelector.registerCategory("ultrarare", new StructureSelector.SimpleCategory(1.25E-4f, Collections.emptyList(), true));
        StructureSelector.registerCategory("adventure", new StructureSelector.SimpleCategory(0.002f, Collections.emptyList(), true));
        OperationRegistry.register("strucGen", OperationGenerateStructure.class);
        OperationRegistry.register("schemGen", OperationGenerateSchematic.class);
        OperationRegistry.register("strucMove", OperationMoveStructure.class);
        Poem.registerThemes("reccomplex", "love", "summer", "war", "winter", "grief");
        RCInventoryGenerators.registerVanillaInventoryGenerators();
        RCBlockRendering.negativeSpaceRenderID = RenderingRegistry.getNextAvailableRenderId();
    }

    protected static void registerDimensionPresets() {
        DimensionMatcherPresets.instance().register("clear", new DimensionGenerationInfo[0]);
        DimensionMatcherPresets.instance().register("overworld", new DimensionGenerationInfo(DimensionMatcher.ofTypes("UNCATEGORIZED"), null), new DimensionGenerationInfo(DimensionMatcher.ofTypes("NO_TOP_LIMIT", "BOTTOM_LIMIT", "INFINITE"), null));
        DimensionMatcherPresets.instance().setDefault("overworld");
        DimensionMatcherPresets.instance().register("nether", new DimensionGenerationInfo(DimensionMatcher.ofTypes("HELL", "TOP_LIMIT", "BOTTOM_LIMIT"), null));
        DimensionMatcherPresets.instance().register("end", new DimensionGenerationInfo(DimensionMatcher.ofTypes("ENDER", "NO_TOP_LIMIT", "NO_BOTTOM_LIMIT"), null));
    }

    protected static void registerBiomePresets() {
        BiomeMatcherPresets.instance().register("clear", new BiomeGenerationInfo[0]);
        BiomeMatcherPresets.instance().register("overworld", new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.WATER), 0.0), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.PLAINS), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.FOREST), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MOUNTAIN), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.HILLS), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SWAMP), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SANDY), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MESA), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SAVANNA), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.WASTELAND), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MUSHROOM), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.JUNGLE), null));
        BiomeMatcherPresets.instance().setDefault("overworld");
        BiomeMatcherPresets.instance().register("underground", new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.PLAINS), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.FOREST), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MOUNTAIN), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.HILLS), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SWAMP), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SANDY), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MESA), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.SAVANNA), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.RIVER), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.OCEAN), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.WASTELAND), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.MUSHROOM), null), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.JUNGLE), null));
        BiomeMatcherPresets.instance().register("ocean", new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.SNOWY), 0.0), new BiomeGenerationInfo(BiomeMatcher.ofTypes(BiomeDictionary.Type.OCEAN), null));
    }

    protected static void registerBlockStatePresets() {
        WeightedBlockStatePresets.instance().register("clear", new WeightedBlockState[0]);
        WeightedBlockState[] wools = new WeightedBlockState[16];
        for (int i = 0; i < wools.length; ++i) {
            wools[i] = new WeightedBlockState(null, Blocks.field_150325_L, i, "");
        }
        WeightedBlockStatePresets.instance().register("allWool", wools);
        WeightedBlockStatePresets.instance().setDefault("allWool");
    }
}

