/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.blocks.SpawnCommandLogic;
import ivorius.reccomplex.blocks.TileEntityWithGUI;
import ivorius.reccomplex.gui.editspawncommandblock.GuiEditSpawnCommandBlock;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.utils.NBTNone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySpawnCommand
extends TileEntity
implements GeneratingTileEntity<NBTNone>,
TileEntityWithGUI {
    public List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> entries) {
        IvCollections.setContentsOfList(this.entries, entries);
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readSyncedNBT(nbtTagCompound);
    }

    @Override
    public void readSyncedNBT(NBTTagCompound nbtTagCompound) {
        this.entries.clear();
        NBTTagList entryNBTs = nbtTagCompound.func_150295_c("commands", 10);
        for (int i = 0; i < entryNBTs.func_74745_c(); ++i) {
            this.entries.add(new Entry(entryNBTs.func_150305_b(i)));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openEditGUI() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditSpawnCommandBlock(this));
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeSyncedNBT(nbtTagCompound);
    }

    @Override
    public void writeSyncedNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList structureNBTList = new NBTTagList();
        for (Entry entry : this.entries) {
            structureNBTList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        nbtTagCompound.func_74782_a("commands", (NBTBase)structureNBTList);
    }

    @Override
    public void generate(StructureSpawnContext context, NBTNone instanceData) {
        if (context.includes(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.entries.size() > 0) {
            Entry entry = (Entry)WeightedSelector.selectItem((Random)context.random, this.entries);
            SpawnCommandLogic logic = new SpawnCommandLogic(this, entry.command);
            try {
                logic.executeCommand(context.world);
            }
            catch (Throwable t) {
                RecurrentComplex.logger.error("Error executing command '%s'", new Object[]{entry.command});
                RecurrentComplex.logger.error("Command execution failed", t);
            }
        }
    }

    @Override
    public boolean shouldPlaceInWorld(StructureSpawnContext context, NBTNone instanceData) {
        return false;
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncedNBT(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeSyncedNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public static class Entry
    implements WeightedSelector.Item {
        public String command;
        public Double weight;

        public Entry(Double weight, String command) {
            this.command = command;
            this.weight = weight;
        }

        public Entry(NBTTagCompound compound) {
            this.command = compound.func_74779_i("command");
            this.weight = compound.func_150297_b("weight", 6) ? Double.valueOf(compound.func_74769_h("weight")) : (compound.func_150297_b("weight", 3) ? Double.valueOf((double)compound.func_74762_e("weight") * 0.01) : null);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("command", this.command);
            if (this.weight != null) {
                compound.func_74780_a("weight", this.weight.doubleValue());
            }
            return compound;
        }

        public double getWeight() {
            return this.weight != null ? this.weight : 1.0;
        }

        public boolean hasDefaultWeight() {
            return this.weight == null;
        }
    }
}

