/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client.rendering;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.rendering.grid.AreaRenderer;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.items.ItemBlockSelectorFloating;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class SelectionRenderer {
    public static ResourceLocation[] TEXTURE;
    public static ResourceLocation[] LATTICE_TEXTURE;

    public static void renderSelection(EntityLivingBase entity, int ticks, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockCoord selPoint1 = null;
        BlockCoord selPoint2 = null;
        StructureEntityInfo structureEntityInfo = StructureEntityInfo.getStructureEntityInfo((Entity)entity);
        if (structureEntityInfo != null) {
            selPoint1 = structureEntityInfo.selectedPoint1;
            selPoint2 = structureEntityInfo.selectedPoint2;
        }
        ItemStack heldItem = entity.func_70694_bm();
        GL11.glLineWidth((float)3.0f);
        if (selPoint1 != null) {
            GL11.glColor3f((float)0.6f, (float)0.8f, (float)0.95f);
            AreaRenderer.renderAreaLined((BlockArea)new BlockArea(selPoint1, selPoint1), (float)0.03f);
        }
        if (selPoint2 != null) {
            GL11.glColor3f((float)0.2f, (float)0.45f, (float)0.65f);
            AreaRenderer.renderAreaLined((BlockArea)new BlockArea(selPoint2, selPoint2), (float)0.04f);
        }
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemBlockSelectorFloating) {
            float selectionRange = ((ItemBlockSelectorFloating)heldItem.func_77973_b()).getSelectionRange(heldItem);
            BlockCoord hoverPoint = ItemBlockSelectorFloating.getHoveredBlock(entity, selectionRange);
            GL11.glColor3f((float)0.6f, (float)0.6f, (float)1.0f);
            AreaRenderer.renderAreaLined((BlockArea)new BlockArea(hoverPoint, hoverPoint), (float)0.05f);
        }
        if (selPoint1 != null && selPoint2 != null) {
            BlockArea selArea = new BlockArea(selPoint1, selPoint2);
            GL11.glColor3f((float)0.4f, (float)0.65f, (float)0.8f);
            AreaRenderer.renderAreaLined((BlockArea)selArea, (float)0.02f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)1.0E-4f);
            ResourceLocation curTex = TEXTURE[MathHelper.func_76141_d((float)(((float)ticks + partialTicks) * 0.75f)) % TEXTURE.length];
            mc.field_71446_o.func_110577_a(curTex);
            GL11.glColor4f((float)0.2f, (float)0.5f, (float)0.6f, (float)0.5f);
            AreaRenderer.renderArea((BlockArea)selArea, (boolean)false, (boolean)true, (float)0.01f);
            GL11.glColor4f((float)0.4f, (float)0.65f, (float)0.8f, (float)0.75f);
            AreaRenderer.renderArea((BlockArea)selArea, (boolean)false, (boolean)false, (float)0.01f);
            GL11.glAlphaFunc((int)516, (float)0.002f);
            GL11.glDisable((int)3042);
        }
    }

    static {
        int i;
        TEXTURE = new ResourceLocation[100];
        for (i = 0; i < TEXTURE.length; ++i) {
            SelectionRenderer.TEXTURE[i] = new ResourceLocation("reccomplex", String.format("%sselection/selection_%05d.png", RecurrentComplex.filePathTextures, i));
        }
        LATTICE_TEXTURE = new ResourceLocation[100];
        for (i = 0; i < LATTICE_TEXTURE.length; ++i) {
            SelectionRenderer.LATTICE_TEXTURE[i] = new ResourceLocation("reccomplex", String.format("%sselection-lattice/lattice_%05d.png", RecurrentComplex.filePathTextures, i));
        }
    }
}

