/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;

public class FileSuffixFilter
implements DirectoryStream.Filter<Path> {
    private Iterable<String> acceptedSuffixes;

    public FileSuffixFilter(Iterable<String> acceptedSuffixes) {
        this.acceptedSuffixes = acceptedSuffixes;
    }

    public FileSuffixFilter(String ... acceptedSuffixes) {
        this(Arrays.asList(acceptedSuffixes));
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        for (String s : this.acceptedSuffixes) {
            if (!FilenameUtils.isExtension((String)entry.getFileName().toString(), (String)s)) continue;
            return true;
        }
        return false;
    }
}

