/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.matchers.DependencyMatcher;
import ivorius.reccomplex.structures.generic.matchers.DimensionMatcher;
import ivorius.reccomplex.utils.ExpressionCache;
import ivorius.reccomplex.utils.IvTranslations;
import java.text.ParseException;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;

public class TableDataSourceExpression<T>
implements TableDataSource,
TableCellPropertyListener {
    public String title;
    private List<String> tooltip;
    public ExpressionCache<T> expressionCache;
    protected TableCellTitle parsed;

    public TableDataSourceExpression(String title, List<String> tooltip, ExpressionCache<T> expressionCache) {
        this.title = title;
        this.tooltip = tooltip;
        this.expressionCache = expressionCache;
    }

    public static <T> TableDataSourceExpression<T> constructDefault(String title, ExpressionCache<T> cache) {
        if (cache instanceof BiomeMatcher) {
            return new TableDataSourceExpression<T>(title, IvTranslations.formatLines("reccomplex.expression.biome.tooltip", new Object[0]), cache);
        }
        if (cache instanceof BlockMatcher) {
            return new TableDataSourceExpression<T>(title, IvTranslations.formatLines("reccomplex.expression.block.tooltip", new Object[0]), cache);
        }
        if (cache instanceof DependencyMatcher) {
            return new TableDataSourceExpression<T>(title, IvTranslations.formatLines("reccomplex.expression.dependency.tooltip", new Object[0]), cache);
        }
        if (cache instanceof DimensionMatcher) {
            return new TableDataSourceExpression<T>(title, IvTranslations.formatLines("reccomplex.expression.dimension.tooltip", new Object[0]), cache);
        }
        throw new IllegalArgumentException();
    }

    public static String parsedString(ExpressionCache expressionCache) {
        if (expressionCache.isExpressionValid()) {
            return expressionCache.getDisplayString();
        }
        ParseException parseException = expressionCache.getParseException();
        return String.format("%s%s%s: at %d", EnumChatFormatting.RED, parseException.getMessage(), EnumChatFormatting.RESET, parseException.getErrorOffset());
    }

    public static GuiValidityStateIndicator.State getValidityState(ExpressionCache<?> expressionCache) {
        return !expressionCache.isExpressionValid() ? GuiValidityStateIndicator.State.INVALID : (expressionCache.containsUnknownVariables() ? GuiValidityStateIndicator.State.SEMI_VALID : GuiValidityStateIndicator.State.VALID);
    }

    @Override
    public int numberOfElements() {
        return 2;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableCellString cell = new TableCellString("expression", this.expressionCache.getExpression());
            if (this.tooltip != null) {
                cell.setTooltip(this.tooltip);
            }
            cell.setShowsValidityState(true);
            cell.setValidityState(TableDataSourceExpression.getValidityState(this.expressionCache));
            cell.addPropertyListener(this);
            return new TableElementCell(this.title, cell);
        }
        if (index == 1) {
            this.parsed = new TableCellTitle("parsedExpression", StringUtils.abbreviate((String)TableDataSourceExpression.parsedString(this.expressionCache), (int)60));
            this.parsed.setPositioning(TableCellTitle.Positioning.TOP);
            return new TableElementCell(this.parsed);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("expression".equals(cell.getID())) {
            this.expressionCache.setExpression((String)cell.getPropertyValue());
            ((TableCellString)cell).setValidityState(TableDataSourceExpression.getValidityState(this.expressionCache));
            if (this.parsed != null) {
                this.parsed.setDisplayString(StringUtils.abbreviate((String)TableDataSourceExpression.parsedString(this.expressionCache), (int)60));
            }
        }
    }
}

