/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.reccomplex.gui.editmazeblock.TableDataSourceSelectionArea;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.Selection;
import java.util.Arrays;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceSelection
extends TableDataSourceList<Selection.Area, Selection> {
    private int[] dimensions;

    public TableDataSourceSelection(Selection list, int[] dimensions, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list, tableDelegate, navigator);
        this.dimensions = dimensions;
    }

    @Override
    public String getDisplayString(Selection.Area area) {
        EnumChatFormatting color = area.isAdditive() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        return String.format("%s%s%s - %s%s", color, Arrays.toString(area.getMinCoord()), EnumChatFormatting.RESET, color, Arrays.toString(area.getMaxCoord()));
    }

    @Override
    public Selection.Area newEntry(String actionID) {
        return new Selection.Area(true, new int[this.dimensions.length], new int[this.dimensions.length]);
    }

    @Override
    public TableDataSource editEntryDataSource(Selection.Area entry) {
        return new TableDataSourceSelectionArea(entry, this.dimensions);
    }
}

