/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editspawncommandblock;

import ivorius.reccomplex.blocks.TileEntitySpawnCommand;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPresetAction;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.utils.IvTranslations;

public class TableDataSourceSpawnCommandEntry
extends TableDataSourceSegmented
implements TableCellPropertyListener,
TableCellActionListener {
    private TileEntitySpawnCommand.Entry entry;
    private TableDelegate tableDelegate;

    public TableDataSourceSpawnCommandEntry(TileEntitySpawnCommand.Entry entry, TableDelegate tableDelegate) {
        this.entry = entry;
        this.tableDelegate = tableDelegate;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 3;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (index == 0) {
            TableCellPresetAction cell = new TableCellPresetAction("default", "Apply", new TableCellButton.Action("spawner", "Mob Spawner"), new TableCellButton.Action("entity", "Spawn Entity"));
            cell.addListener(this);
            return new TableElementCell("Preset", cell);
        }
        if (index == 1) {
            TableCellString cell = new TableCellString("command", this.entry.command);
            cell.addPropertyListener(this);
            return new TableElementCell("Command", cell);
        }
        if (index == 2) {
            TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.entry.weight), 1.0f, 0.0f, 10.0f, "D", "C");
            cell.addPropertyListener(this);
            cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
            return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("command".equals(cell.getID())) {
            this.entry.command = (String)cell.getPropertyValue();
        } else if ("weight".equals(cell.getID())) {
            this.entry.weight = TableElements.toDouble((Float)cell.getPropertyValue());
        }
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("default".equals(cell.getID())) {
            if ("spawner".equals(actionID)) {
                this.entry.command = "/setblock ~ ~ ~ mob_spawner 0 replace {EntityId:Zombie}";
            } else if ("entity".equals(actionID)) {
                this.entry.command = "/summon Zombie ~ ~ ~";
            }
            this.tableDelegate.reloadData();
        }
    }
}

