/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.structures.generic.WeightedBlockState;
import ivorius.reccomplex.utils.IvTranslations;
import net.minecraft.block.Block;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class TableDataSourceWeightedBlockState
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private WeightedBlockState weightedBlockState;
    private TableDelegate tableDelegate;
    private TableCellTitle parsed;

    public TableDataSourceWeightedBlockState(WeightedBlockState weightedBlockState, TableDelegate tableDelegate) {
        this.weightedBlockState = weightedBlockState;
        this.tableDelegate = tableDelegate;
    }

    public static GuiValidityStateIndicator.State stateForNBTCompoundJson(String json) {
        if (json.length() == 0) {
            return GuiValidityStateIndicator.State.VALID;
        }
        try {
            NBTBase nbtbase = JsonToNBT.func_150315_a((String)json);
            if (nbtbase instanceof NBTTagCompound) {
                return GuiValidityStateIndicator.State.VALID;
            }
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
        return GuiValidityStateIndicator.State.INVALID;
    }

    @Override
    public int numberOfSegments() {
        return 3;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 2 : 1;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.weightedBlockState.weight), 1.0f, 0.0f, 10.0f, "D", "C");
            cell.addPropertyListener(this);
            cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
            return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
        }
        if (segment == 1) {
            if (index == 0) {
                TableCellString cell = TableDataSourceBTNatural.elementForBlock("block", this.weightedBlockState.block);
                cell.addPropertyListener(this);
                return new TableElementCell("Block", cell);
            }
            if (index == 1) {
                TableCellInteger cell = new TableCellInteger("metadata", this.weightedBlockState.metadata, 0, 15);
                cell.addPropertyListener(this);
                return new TableElementCell("Metadata", cell);
            }
        } else if (segment == 2) {
            TableCellString cell = new TableCellString("tileEntityInfo", this.weightedBlockState.tileEntityInfo);
            cell.addPropertyListener(this);
            cell.setShowsValidityState(true);
            cell.setValidityState(TableDataSourceWeightedBlockState.stateForNBTCompoundJson(this.weightedBlockState.tileEntityInfo));
            return new TableElementCell("Tile Entity NBT", cell);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("weight".equals(cell.getID())) {
            this.weightedBlockState.weight = TableElements.toDouble((Float)cell.getPropertyValue());
        } else if ("block".equals(cell.getID())) {
            this.weightedBlockState.block = (Block)Block.field_149771_c.func_82594_a(cell.getPropertyValue());
            TableDataSourceBTNatural.setStateForBlockTextfield((TableCellString)cell);
        } else if ("metadata".equals(cell.getID())) {
            this.weightedBlockState.metadata = (Integer)cell.getPropertyValue();
        } else if ("tileEntityInfo".equals(cell.getID())) {
            this.weightedBlockState.tileEntityInfo = (String)cell.getPropertyValue();
            ((TableCellString)cell).setValidityState(TableDataSourceWeightedBlockState.stateForNBTCompoundJson(this.weightedBlockState.tileEntityInfo));
        }
    }
}

