/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.structures.generic.transformers.TransformerNaturalAir;
import ivorius.reccomplex.utils.IvTranslations;

public class TableDataSourceBTNaturalAir
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TransformerNaturalAir transformer;

    public TableDataSourceBTNaturalAir(TransformerNaturalAir transformer) {
        this.transformer = transformer;
        this.addManagedSection(0, TableDataSourceExpression.constructDefault("Sources", transformer.sourceMatcher));
    }

    public TransformerNaturalAir getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerNaturalAir transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 2 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            switch (index) {
                case 0: {
                    TableCellFloatNullable element = new TableCellFloatNullable("naturalExpansionDistance", TableElements.toFloat(this.transformer.naturalExpansionDistance), 1.0f, 0.0f, 20.0f, "D", "C");
                    element.addPropertyListener(this);
                    element.setTooltip(IvTranslations.formatLines("reccomplex.transformer.naturalAir.naturalExpansionDistance.tooltip", new Object[0]));
                    return new TableElementCell(IvTranslations.get("reccomplex.transformer.naturalAir.naturalExpansionDistance"), element);
                }
                case 1: {
                    TableCellFloatNullable element = new TableCellFloatNullable("naturalExpansionRandomization", TableElements.toFloat(this.transformer.naturalExpansionRandomization), 1.0f, 0.0f, 20.0f, "D", "C");
                    element.addPropertyListener(this);
                    element.setTooltip(IvTranslations.formatLines("reccomplex.transformer.naturalAir.naturalExpansionRandomization.tooltip", new Object[0]));
                    return new TableElementCell(IvTranslations.get("reccomplex.transformer.naturalAir.naturalExpansionRandomization"), element);
                }
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "naturalExpansionDistance": {
                    this.transformer.naturalExpansionDistance = TableElements.toDouble((Float)cell.getPropertyValue());
                    break;
                }
                case "naturalExpansionRandomization": {
                    this.transformer.naturalExpansionRandomization = TableElements.toDouble((Float)cell.getPropertyValue());
                }
            }
        }
    }
}

