/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSliderMultivalue;
import ivorius.ivtoolkit.gui.GuiSliderRange;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import net.minecraft.client.gui.GuiButton;

public class TableCellFloatRange
extends TableCellPropertyDefault<FloatRange>
implements GuiControlListener<GuiSliderMultivalue> {
    private GuiSliderRange slider;
    private int floatDisplayPrecision;
    private boolean enabled = true;
    private float min;
    private float max;

    public TableCellFloatRange(String id, FloatRange value, float min, float max, int floatDisplayPrecision) {
        super(id, value);
        this.min = min;
        this.max = max;
        this.floatDisplayPrecision = floatDisplayPrecision;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.slider = new GuiSliderRange(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, this.getRangeString());
        this.slider.setMinValue(this.min);
        this.slider.setMaxValue(this.max);
        this.slider.field_146124_l = this.enabled;
        this.slider.addListener((GuiControlListener)this);
        this.slider.setRange((FloatRange)this.property);
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, (GuiButton)this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    public void valueChanged(GuiSliderMultivalue gui) {
        this.property = this.slider.getRange();
        this.slider.field_146126_j = this.getRangeString();
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(FloatRange value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setRange(value);
            this.slider.field_146126_j = this.getRangeString();
        }
    }

    private String getRangeString() {
        return TableCellFloatRange.getNumberString(((FloatRange)this.property).getMin(), this.floatDisplayPrecision) + " - " + TableCellFloatRange.getNumberString(((FloatRange)this.property).getMax(), this.floatDisplayPrecision);
    }

    private static String getNumberString(float number, int precision) {
        return String.format("%." + precision + "f", Float.valueOf(number));
    }
}

