/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellPresetAction;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public abstract class TableDataSourceList<T, L extends List<T>>
extends TableDataSourceSegmented
implements TableCellActionListener {
    protected L list;
    protected TableDelegate tableDelegate;
    protected TableNavigator navigator;
    protected String earlierTitle = "Earlier";
    protected String laterTitle = "Later";
    protected String editTitle = "Edit";
    protected String deleteTitle = EnumChatFormatting.RED + "-";
    protected String addTitle = EnumChatFormatting.GREEN + "+";
    protected boolean usesPresetActionForAdding;

    public TableDataSourceList(L list, TableDelegate tableDelegate, TableNavigator navigator) {
        this.list = list;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
    }

    public L getList() {
        return this.list;
    }

    public void setList(L list) {
        this.list = list;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    public String getEarlierTitle() {
        return this.earlierTitle;
    }

    public void setEarlierTitle(String earlierTitle) {
        this.earlierTitle = earlierTitle;
    }

    public String getLaterTitle() {
        return this.laterTitle;
    }

    public void setLaterTitle(String laterTitle) {
        this.laterTitle = laterTitle;
    }

    public String getEditTitle() {
        return this.editTitle;
    }

    public void setEditTitle(String editTitle) {
        this.editTitle = editTitle;
    }

    public String getDeleteTitle() {
        return this.deleteTitle;
    }

    public void setDeleteTitle(String deleteTitle) {
        this.deleteTitle = deleteTitle;
    }

    public String getAddTitle() {
        return this.addTitle;
    }

    public void setAddTitle(String addTitle) {
        this.addTitle = addTitle;
    }

    public boolean isUsesPresetActionForAdding() {
        return this.usesPresetActionForAdding;
    }

    public void setUsesPresetActionForAdding(boolean usesPresetActionForAdding) {
        this.usesPresetActionForAdding = usesPresetActionForAdding;
    }

    @Override
    public int numberOfSegments() {
        return 3;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (this.isListSegment(segment)) {
            return this.list.size();
        }
        int addIndex = this.getAddIndex(segment);
        if (addIndex >= 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (this.isListSegment(segment)) {
            Object t = this.list.get(index);
            TableCellButton cell = new TableCellButton("entry" + index, this.getEntryActions(index));
            cell.addListener(this);
            return new TableElementCell(this.getDisplayString(t), cell);
        }
        int addIndex = this.getAddIndex(segment);
        if (addIndex >= 0) {
            if (this.isUsesPresetActionForAdding()) {
                TableCellPresetAction cell = new TableCellPresetAction("add" + addIndex, this.getAddTitle(), this.getAddActions());
                cell.setActionButtonWidth(0.2f);
                cell.addListener(this);
                return new TableElementCell(cell);
            }
            TableCellButton cell = new TableCellButton("add" + addIndex, this.getAddActions());
            cell.addListener(this);
            return new TableElementCell(cell);
        }
        return null;
    }

    public boolean isListSegment(int segment) {
        return segment == 1;
    }

    public int getAddIndex(int segment) {
        return segment == 0 ? 0 : (segment == 2 ? (this.list.size() > 0 ? this.list.size() : -1) : -1);
    }

    public TableCellButton.Action[] getAddActions() {
        boolean enabled = this.canEditList();
        return new TableCellButton.Action[]{new TableCellButton.Action("add", this.getAddTitle(), enabled)};
    }

    public TableCellButton.Action[] getEntryActions(int index) {
        boolean enabled = this.canEditList();
        return new TableCellButton.Action[]{new TableCellButton.Action("earlier", this.getEarlierTitle(), index > 0 && enabled), new TableCellButton.Action("later", this.getLaterTitle(), index < this.list.size() - 1 && enabled), new TableCellButton.Action("edit", this.getEditTitle(), enabled), new TableCellButton.Action("delete", this.getDeleteTitle(), enabled)};
    }

    public boolean canEditList() {
        return true;
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if (cell.getID() != null) {
            if (cell.getID().startsWith("add")) {
                T entry = this.newEntry(actionID);
                if (entry != null) {
                    int addIndex = Integer.valueOf(cell.getID().substring("add".length()));
                    this.list.add(addIndex, entry);
                    this.navigator.pushTable(new GuiTable(this.tableDelegate, this.editEntryDataSource(entry)));
                }
            } else if (cell.getID().startsWith("entry")) {
                int index = Integer.valueOf(cell.getID().substring("entry".length()));
                Object entry = this.list.get(index);
                this.performEntryAction(actionID, index, entry);
            }
        }
    }

    public void performEntryAction(String actionID, int index, T t) {
        switch (actionID) {
            case "edit": {
                this.navigator.pushTable(new GuiTable(this.tableDelegate, this.editEntryDataSource(t)));
                break;
            }
            case "delete": {
                this.list.remove(index);
                this.tableDelegate.reloadData();
                break;
            }
            case "earlier": {
                this.list.remove(index);
                this.list.add(index - 1, t);
                this.tableDelegate.reloadData();
                break;
            }
            case "later": {
                this.list.remove(index);
                this.list.add(index + 1, t);
                this.tableDelegate.reloadData();
            }
        }
    }

    public abstract String getDisplayString(T var1);

    public abstract T newEntry(String var1);

    public abstract TableDataSource editEntryDataSource(T var1);
}

