/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.inventorygen.GuiEditInvGenMultiTag;
import ivorius.reccomplex.items.ItemInventoryGenerationTag;
import ivorius.reccomplex.items.ItemSyncable;
import ivorius.reccomplex.utils.IvItemStacks;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollection;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;

public class ItemInventoryGenMultiTag
extends ItemInventoryGenerationTag
implements ItemSyncable {
    public static TIntList emptySlots(IInventory inv) {
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            list.add(i);
        }
        return list;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            this.openGui(player, player.field_71071_by.field_70461_c);
        }
        return super.func_77659_a(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, int slot) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditInvGenMultiTag(player, slot));
    }

    @Override
    public void generateInInventory(IInventory inventory, Random random, ItemStack stack, int fromSlot) {
        WeightedItemCollection weightedItemCollection = ItemInventoryGenMultiTag.inventoryGenerator(stack);
        inventory.func_70299_a(fromSlot, null);
        if (weightedItemCollection != null) {
            IntegerRange range = this.getGenerationCount(stack);
            int amount = range.getMin() < range.getMax() ? random.nextInt(range.getMax() - range.getMin() + 1) + range.getMin() : 0;
            TIntList emptySlots = ItemInventoryGenMultiTag.emptySlots(inventory);
            for (int i = 0; i < amount; ++i) {
                int slot = emptySlots.isEmpty() ? random.nextInt(inventory.func_70302_i_()) : emptySlots.removeAt(random.nextInt(emptySlots.size()));
                inventory.func_70299_a(slot, weightedItemCollection.getRandomItemStack(random));
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedInformation) {
        super.func_77624_a(stack, player, list, advancedInformation);
        IntegerRange range = this.getGenerationCount(stack);
        list.add(String.format("%d - %d Items", range.getMin(), range.getMax()));
    }

    public IntegerRange getGenerationCount(ItemStack stack) {
        return new IntegerRange(IvItemStacks.getNBTInt(stack, "itemCountMin", 4), IvItemStacks.getNBTInt(stack, "itemCountMax", 8));
    }

    public void setGenerationCount(ItemStack stack, IntegerRange range) {
        stack.func_77983_a("itemCountMin", (NBTBase)new NBTTagInt(range.getMin()));
        stack.func_77983_a("itemCountMax", (NBTBase)new NBTTagInt(range.getMax()));
    }

    @Override
    public void writeSyncedNBT(NBTTagCompound compound, ItemStack stack) {
        IntegerRange range = this.getGenerationCount(stack);
        compound.func_74768_a("itemCountMin", range.getMin());
        compound.func_74768_a("itemCountMax", range.getMax());
    }

    @Override
    public void readSyncedNBT(NBTTagCompound compound, ItemStack stack) {
        this.setGenerationCount(stack, new IntegerRange(compound.func_74762_e("itemCountMin"), compound.func_74762_e("itemCountMax")));
    }
}

