/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.BlockQuadCache;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.worldgen.StructureGenerator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OperationGenerateStructure
implements Operation {
    public GenericStructureInfo structure;
    public AxisAlignedTransform2D transform;
    public BlockCoord lowerCoord;
    public boolean generateAsSource;
    public String structureIDForSaving;
    protected GridQuadCache cachedShapeGrid;

    public OperationGenerateStructure() {
    }

    public OperationGenerateStructure(GenericStructureInfo structure, AxisAlignedTransform2D transform, BlockCoord lowerCoord, boolean generateAsSource) {
        this.structure = structure;
        this.transform = transform;
        this.lowerCoord = lowerCoord;
        this.generateAsSource = generateAsSource;
    }

    public OperationGenerateStructure(GenericStructureInfo structure, AxisAlignedTransform2D transform, BlockCoord lowerCoord, boolean generateAsSource, String structureIDForSaving) {
        this.structure = structure;
        this.transform = transform;
        this.lowerCoord = lowerCoord;
        this.generateAsSource = generateAsSource;
        this.structureIDForSaving = structureIDForSaving;
    }

    public String getStructureIDForSaving() {
        return this.structureIDForSaving;
    }

    public void setStructureIDForSaving(String structureIDForSaving) {
        this.structureIDForSaving = structureIDForSaving;
    }

    @Override
    public void perform(World world) {
        if (this.generateAsSource) {
            StructureGenerator.directly(this.structure, new StructureSpawnContext(world, world.field_73012_v, this.lowerCoord, this.transform, 0, this.generateAsSource, this.structure));
        } else {
            StructureGenerator.instantly(this.structure, world, world.field_73012_v, this.lowerCoord, this.transform, 0, false, this.structureIDForSaving, this.generateAsSource);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("structureInfo", StructureRegistry.createJSONFromStructure(this.structure));
        compound.func_74782_a("structureData", (NBTBase)this.structure.worldDataCompound);
        compound.func_74768_a("rotation", this.transform.getRotation());
        compound.func_74757_a("mirrorX", this.transform.isMirrorX());
        BlockCoord.writeCoordToNBT((String)"lowerCoord", (BlockCoord)this.lowerCoord, (NBTTagCompound)compound);
        compound.func_74757_a("generateAsSource", this.generateAsSource);
        if (this.structureIDForSaving != null) {
            compound.func_74778_a("structureIDForSaving", this.structureIDForSaving);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.structure = StructureRegistry.createStructureFromJSON(compound.func_74779_i("structureInfo"));
        this.structure.worldDataCompound = compound.func_74775_l("structureData");
        this.transform = new AxisAlignedTransform2D(compound.func_74762_e("rotation"), compound.func_74767_n("mirrorX"));
        this.lowerCoord = BlockCoord.readCoordFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
        this.generateAsSource = compound.func_74767_n("generateAsSource");
        this.structureIDForSaving = compound.func_150297_b("structureIDForSaving", 8) ? compound.func_74779_i("structureIDForSaving") : null;
    }

    public void invalidateCache() {
        this.cachedShapeGrid = null;
    }

    @Override
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        int[] size = this.structure.structureBoundingBox();
        if (previewType == Operation.PreviewType.SHAPE) {
            GL11.glColor3f((float)0.8f, (float)0.75f, (float)1.0f);
            OperationRenderer.renderGridQuadCache(this.cachedShapeGrid != null ? this.cachedShapeGrid : (this.cachedShapeGrid = BlockQuadCache.createQuadCache((IvBlockCollection)this.structure.constructWorldData((World)world).blockCollection, (float[])new float[]{1.0f, 1.0f, 1.0f})), this.transform, this.lowerCoord, ticks, partialTicks);
        }
        if (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE) {
            OperationRenderer.maybeRenderBoundingBox(this.lowerCoord, StructureInfos.structureSize(size, this.transform), ticks, partialTicks);
        }
    }
}

