/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.AreaRenderer;
import ivorius.ivtoolkit.rendering.grid.BlockQuadCache;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.structures.OperationGenerateStructure;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OperationMoveStructure
extends OperationGenerateStructure {
    public BlockArea sourceArea;

    public OperationMoveStructure() {
    }

    public OperationMoveStructure(GenericStructureInfo structure, AxisAlignedTransform2D transform, BlockCoord lowerCoord, boolean generateAsSource, BlockArea sourceArea) {
        super(structure, transform, lowerCoord, generateAsSource);
        this.sourceArea = sourceArea;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        BlockCoord.writeCoordToNBT((String)"sourcePoint1", (BlockCoord)this.sourceArea.getPoint1(), (NBTTagCompound)compound);
        BlockCoord.writeCoordToNBT((String)"sourcePoint2", (BlockCoord)this.sourceArea.getPoint2(), (NBTTagCompound)compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.sourceArea = new BlockArea(BlockCoord.readCoordFromNBT((String)"sourcePoint1", (NBTTagCompound)compound), BlockCoord.readCoordFromNBT((String)"sourcePoint2", (NBTTagCompound)compound));
    }

    @Override
    public void perform(World world) {
        for (BlockCoord coord : this.sourceArea) {
            OperationMoveStructure.setBlockToAirClean(world, coord);
        }
        super.perform(world);
    }

    public static void setBlockToAirClean(World world, BlockCoord blockCoord) {
        TileEntity tileEntity = world.func_147438_o(blockCoord.x, blockCoord.y, blockCoord.z);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                inventory.func_70299_a(i, null);
            }
        }
        world.func_147468_f(blockCoord.x, blockCoord.y, blockCoord.z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        int[] size = this.structure.structureBoundingBox();
        if (previewType == Operation.PreviewType.SHAPE) {
            GL11.glColor3f((float)0.8f, (float)0.75f, (float)1.0f);
            OperationRenderer.renderGridQuadCache(this.cachedShapeGrid != null ? this.cachedShapeGrid : (this.cachedShapeGrid = BlockQuadCache.createQuadCache((IvBlockCollection)this.structure.constructWorldData((World)world).blockCollection, (float[])new float[]{1.0f, 1.0f, 1.0f})), this.transform, this.lowerCoord, ticks, partialTicks);
        }
        if (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE) {
            OperationRenderer.maybeRenderBoundingBox(this.lowerCoord, StructureInfos.structureSize(size, this.transform), ticks, partialTicks);
            GL11.glLineWidth((float)3.0f);
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
            AreaRenderer.renderAreaLined((BlockArea)this.sourceArea, (float)0.0212f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)1.0E-4f);
            ResourceLocation curTex = SelectionRenderer.TEXTURE[MathHelper.func_76141_d((float)(((float)ticks + partialTicks) * 0.75f)) % SelectionRenderer.TEXTURE.length];
            Minecraft.func_71410_x().field_71446_o.func_110577_a(curTex);
            GL11.glColor4f((float)0.3f, (float)0.3f, (float)0.4f, (float)0.2f);
            AreaRenderer.renderArea((BlockArea)this.sourceArea, (boolean)false, (boolean)true, (float)0.0112f);
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.5f, (float)0.35f);
            AreaRenderer.renderArea((BlockArea)this.sourceArea, (boolean)false, (boolean)false, (float)0.0112f);
            GL11.glAlphaFunc((int)516, (float)0.002f);
            GL11.glDisable((int)3042);
        }
    }
}

