/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;

public class WeightedBlockState
implements WeightedSelector.Item {
    private static Gson gson = WeightedBlockState.createGson();
    public Double weight;
    public Block block;
    public int metadata;
    public String tileEntityInfo;

    public WeightedBlockState(Double weight, Block block, int metadata, String tileEntityInfo) {
        this.weight = weight;
        this.block = block;
        this.metadata = metadata;
        this.tileEntityInfo = tileEntityInfo;
    }

    public WeightedBlockState(MCRegistry registry, NBTTagCompound compound) {
        this.weight = compound.func_74764_b("weight") ? Double.valueOf(compound.func_74769_h("weight")) : null;
        this.block = compound.func_74764_b("block") ? registry.blockFromID(compound.func_74779_i("block")) : null;
        this.metadata = compound.func_74762_e("meta");
        this.tileEntityInfo = compound.func_74779_i("tileEntityInfo");
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(WeightedBlockState.class, (Object)new Serializer(MCRegistrySpecial.INSTANCE));
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public double getWeight() {
        return this.weight != null ? this.weight : 1.0;
    }

    public NBTTagCompound writeToNBT(MCRegistry registry) {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.weight != null) {
            compound.func_74780_a("weight", this.weight.doubleValue());
        }
        if (this.block != null) {
            compound.func_74778_a("block", registry.idFromBlock(this.block));
        }
        compound.func_74768_a("meta", this.metadata);
        compound.func_74778_a("tileEntityInfo", this.tileEntityInfo);
        return compound;
    }

    public static class Serializer
    implements JsonDeserializer<WeightedBlockState>,
    JsonSerializer<WeightedBlockState> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public WeightedBlockState deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "blockState");
            Double weight = jsonObject.has("weight") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "weight")) : null;
            String block = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "block", "air");
            int metadata = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, "metadata", 0);
            String tileEntityInfo = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "tileEntityInfo", "");
            return new WeightedBlockState(weight, this.registry.blockFromID(block), metadata, tileEntityInfo);
        }

        public JsonElement serialize(WeightedBlockState generationInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (generationInfo.weight != null) {
                jsonObject.addProperty("weight", (Number)generationInfo.weight);
            }
            jsonObject.addProperty("block", this.registry.idFromBlock(generationInfo.block));
            jsonObject.addProperty("metadata", (Number)generationInfo.metadata);
            jsonObject.addProperty("tileEntityInfo", generationInfo.tileEntityInfo);
            return jsonObject;
        }
    }
}

