/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.utils.NBTStorable;
import net.minecraft.nbt.NBTTagCompound;

public class PlacedStructure
implements NBTCompoundObject {
    public String structureID;
    public AxisAlignedTransform2D transform;
    public BlockCoord lowerCoord;
    public NBTStorable instanceData;

    public PlacedStructure(String structureID, AxisAlignedTransform2D transform, BlockCoord lowerCoord, NBTStorable instanceData) {
        this.structureID = structureID;
        this.transform = transform;
        this.lowerCoord = lowerCoord;
        this.instanceData = instanceData;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.structureID = compound.func_74779_i("structureID");
        this.transform = new AxisAlignedTransform2D(compound.func_74762_e("rotation"), compound.func_74767_n("mirrorX"));
        this.lowerCoord = BlockCoord.readCoordFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
        StructureInfo structureInfo = StructureRegistry.getStructure(this.structureID);
        this.instanceData = compound.func_150297_b("instanceData", 10) && structureInfo != null ? structureInfo.loadInstanceData(new StructureLoadContext(this.transform, StructureInfos.structureBoundingBox(this.lowerCoord, StructureInfos.structureSize(structureInfo, this.transform)), false), compound.func_74781_a("instanceData")) : null;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("structureID", this.structureID);
        compound.func_74768_a("rotation", this.transform.getRotation());
        compound.func_74757_a("mirrorX", this.transform.isMirrorX());
        BlockCoord.writeCoordToNBT((String)"lowerCoord", (BlockCoord)this.lowerCoord, (NBTTagCompound)compound);
        if (this.instanceData != null) {
            compound.func_74782_a("instanceData", this.instanceData.writeToNBT());
        }
    }
}

