/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.structures.generic.matchers.BiomeMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.commons.lang3.tuple.Pair;

public class StructureSelector {
    public static final int STRUCTURE_MIN_CAP_DEFAULT = 20;
    private static Map<String, Category> categories = new HashMap<String, Category>();
    private Multimap<String, WeightedSelector.SimpleItem<Pair<StructureInfo, NaturalGenerationInfo>>> weightedStructureInfos = ArrayListMultimap.create();
    private final Set<String> cachedDimensionTypes = new HashSet<String>();

    public StructureSelector(Collection<StructureInfo> structures, BiomeGenBase biome, WorldProvider provider) {
        this.cachedDimensionTypes.addAll(DimensionDictionary.getDimensionTypes(provider));
        for (StructureInfo structureInfo : structures) {
            List<NaturalGenerationInfo> generationInfos = structureInfo.generationInfos(NaturalGenerationInfo.class);
            for (NaturalGenerationInfo naturalGenerationInfo : generationInfos) {
                double generationWeight = naturalGenerationInfo.getGenerationWeight(biome, provider);
                if (!(generationWeight > 0.0)) continue;
                this.weightedStructureInfos.put((Object)naturalGenerationInfo.generationCategory, (Object)new WeightedSelector.SimpleItem(generationWeight, (Object)Pair.of((Object)structureInfo, (Object)naturalGenerationInfo)));
            }
        }
    }

    public static void registerCategory(String id, Category category) {
        categories.put(id, category);
    }

    public static Category categoryForID(String id) {
        return categories.get(id);
    }

    public static Set<String> allCategoryIDs() {
        return categories.keySet();
    }

    public boolean isValid(BiomeGenBase biome, WorldProvider provider) {
        return DimensionDictionary.getDimensionTypes(provider).equals(this.cachedDimensionTypes);
    }

    public float generationChance(String category, BiomeGenBase biome) {
        Category categoryObj = StructureSelector.categoryForID(category);
        if (categoryObj != null) {
            return categoryObj.structureSpawnChance(biome, this.weightedStructureInfos.get((Object)category).size()) * RCConfig.structureSpawnChanceModifier;
        }
        return 0.0f;
    }

    public List<Pair<StructureInfo, NaturalGenerationInfo>> generatedStructures(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<Pair<StructureInfo, NaturalGenerationInfo>> infos = new ArrayList<Pair<StructureInfo, NaturalGenerationInfo>>();
        BiomeGenBase biome = world.func_72807_a(chunkX * 16, chunkZ * 16);
        for (String category : this.weightedStructureInfos.keySet()) {
            if (!(random.nextFloat() < this.generationChance(category, biome))) continue;
            infos.add((Pair<StructureInfo, NaturalGenerationInfo>)WeightedSelector.select((Random)random, (Collection)this.weightedStructureInfos.get((Object)category)));
        }
        return infos;
    }

    public static class GenerationInfo {
        public float spawnChance;
        public BiomeMatcher selector;

        public GenerationInfo(float spawnChance, BiomeMatcher selector) {
            this.spawnChance = spawnChance;
            this.selector = selector;
        }
    }

    public static class SimpleCategory
    implements Category {
        public float defaultSpawnChance;
        public List<GenerationInfo> generationInfos;
        public boolean selectableInGUI;
        public int structureMinCap;

        public SimpleCategory(float defaultSpawnChance, List<GenerationInfo> generationInfos, boolean selectableInGUI, int structureMinCap) {
            this.defaultSpawnChance = defaultSpawnChance;
            this.generationInfos = generationInfos;
            this.selectableInGUI = selectableInGUI;
            this.structureMinCap = structureMinCap;
        }

        public SimpleCategory(float defaultSpawnChance, List<GenerationInfo> generationInfos, boolean selectableInGUI) {
            this(defaultSpawnChance, generationInfos, selectableInGUI, 20);
        }

        @Override
        public float structureSpawnChance(BiomeGenBase biome, int registeredStructures) {
            float amountMultiplier = Math.min((float)registeredStructures / (float)this.structureMinCap, 1.0f);
            for (GenerationInfo info : this.generationInfos) {
                if (!info.selector.apply(biome)) continue;
                return info.spawnChance * amountMultiplier;
            }
            return this.defaultSpawnChance * amountMultiplier;
        }

        @Override
        public boolean selectableInGUI() {
            return this.selectableInGUI;
        }
    }

    public static interface Category {
        public float structureSpawnChance(BiomeGenBase var1, int var2);

        public boolean selectableInGUI();
    }
}

